/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupForms;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

public class EmailDataHelper {
    private static final Log log = LogFactory.getLog(EmailDataHelper.class);

    protected static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static Sending getUserSending(Session session, User user) {
        String id = user.getWikittyId();
        return EmailDataHelper.getUserSending(session, id);
    }

    public static List<Sending> getUsersSendings(Session session, Collection<String> usersId) {
        if (session == null || usersId == null) {
            return null;
        }
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return null;
        }
        ArrayList<String> sendingIds = new ArrayList<String>(sendingIdsSet);
        List sendings = EmailDataHelper.getProxy().restore(Sending.class, sendingIds);
        ArrayList<Sending> result = new ArrayList<Sending>();
        for (Sending sending : sendings) {
            if (sending == null || !usersId.contains(sending.getUser())) continue;
            result.add(sending);
        }
        return result;
    }

    public static Sending getUserSending(Session session, String userId) {
        if (session == null) {
            return null;
        }
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return null;
        }
        ArrayList<String> sendingIds = new ArrayList<String>(sendingIdsSet);
        List sendings = EmailDataHelper.getProxy().restore(Sending.class, sendingIds);
        for (Sending sending : sendings) {
            if (sending == null || !userId.equals(sending.getUser())) continue;
            return sending;
        }
        return null;
    }

    public static int getNbFormToSend(Session session, User bean) {
        Sending sending = EmailDataHelper.getUserSending(session, bean);
        Set formIds = null;
        if (sending != null) {
            formIds = SendingHelper.extractForms((WikittyProxy)EmailDataHelper.getProxy(), sending.getGroupForms());
        }
        return formIds == null ? 0 : formIds.size();
    }

    public static int getNbFormToSend(Session session, Group group) {
        HashSet formIds = new HashSet();
        Set<String> userIds = group.getUser();
        if (userIds != null) {
            for (String userId : userIds) {
                Set formsIds;
                Sending sending = EmailDataHelper.getUserSending(session, userId);
                if (sending == null || (formsIds = SendingHelper.extractForms((WikittyProxy)EmailDataHelper.getProxy(), sending.getGroupForms())) == null) continue;
                formIds.addAll(formsIds);
            }
        }
        return formIds.size();
    }

    public static String convertFormsToString(List<Form> forms) {
        List<String> objects = EmailDataHelper.extractObject(forms);
        return StringUtils.join(objects, (String)",\n");
    }

    public static String convertFormsIdsToString(List<String> formsId) {
        List forms = VradiService.getWikittyProxy().restore(Form.class, formsId);
        return EmailDataHelper.convertFormsToString(forms);
    }

    public static <E extends BusinessEntity> String convertObjectBeanToString(List beans, Class<E> clazz) {
        ArrayList<BusinessEntity> casted = new ArrayList<BusinessEntity>();
        for (Object o : beans) {
            casted.add((BusinessEntity)o);
        }
        return EmailDataHelper.convertBeanToString(casted);
    }

    public static String convertBeanToString(List<? extends BusinessEntity> beans) {
        List<String> names = EmailDataHelper.extractNames(beans);
        return StringUtils.join(names, (String)",\n");
    }

    protected static List<String> extractObject(List<Form> forms) {
        ArrayList<String> objects = new ArrayList<String>();
        for (Form f : forms) {
            objects.add(f.getObjet());
        }
        return objects;
    }

    protected static List<String> extractNames(List<? extends BusinessEntity> beans) {
        ArrayList<String> beansAsNames = new ArrayList<String>();
        for (BusinessEntity businessEntity : beans) {
            beansAsNames.add(VradiHelper.getEntityName(businessEntity));
        }
        return beansAsNames;
    }

    public static String convertFormToString(String formId) {
        Form form = (Form)VradiService.getWikittyProxy().restore(Form.class, formId);
        if (form != null) {
            return form.getObjet();
        }
        return "";
    }

    public static List<Sending> getAllSending(Session session) {
        Set<String> sendingSetIds = session.getSending();
        if (sendingSetIds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> sendingIds = new ArrayList<String>(sendingSetIds);
        WikittyProxy proxy = VradiService.getWikittyProxy();
        return proxy.restore(Sending.class, sendingIds);
    }

    public static List<User> getUsersSendingConcernedBy(Session session, String formId) {
        HashSet<String> userSet = new HashSet<String>();
        List<Sending> sendings = EmailDataHelper.getAllSending(session);
        for (Sending sending : sendings) {
            Set deletedFormsIds;
            if (sending == null) continue;
            ArrayList allFormsIds = new ArrayList();
            Set formsIds = SendingHelper.extractForms((WikittyProxy)EmailDataHelper.getProxy(), sending.getGroupForms());
            if (formsIds != null) {
                allFormsIds.addAll(formsIds);
            }
            if ((deletedFormsIds = SendingHelper.extractForms((WikittyProxy)EmailDataHelper.getProxy(), sending.getDeletedGroupForms())) != null) {
                allFormsIds.addAll(deletedFormsIds);
            }
            if (!allFormsIds.contains(formId)) continue;
            String userId = sending.getUser();
            userSet.add(userId);
        }
        List result = VradiService.getWikittyProxy().restore(User.class, new ArrayList(userSet));
        Collections.sort(result, VradiComparators.USER_COMPARATOR);
        return result;
    }

    public static List<Group> getGroupsSendingConcernedBy(Session session, String formId) {
        HashSet<String> groupsSet = new HashSet<String>();
        HashSet<String> groupFormsIdsOfSession = new HashSet<String>();
        for (Sending sending : EmailDataHelper.getAllSending(session)) {
            Set<String> deletedGroupFormsIds;
            Set<String> groupFormsIds = sending.getGroupForms();
            if (groupFormsIds != null) {
                groupFormsIdsOfSession.addAll(groupFormsIds);
            }
            if ((deletedGroupFormsIds = sending.getDeletedGroupForms()) == null) continue;
            groupFormsIdsOfSession.addAll(deletedGroupFormsIds);
        }
        List groupFormsOfSession = EmailDataHelper.getProxy().restore(GroupForms.class, new ArrayList(groupFormsIdsOfSession));
        for (GroupForms gf : groupFormsOfSession) {
            String groupId;
            Set<String> formsIds;
            if (gf == null || (formsIds = gf.getForm()) == null || !formsIds.contains(formId) || (groupId = gf.getGroup()) == null) continue;
            groupsSet.add(groupId);
        }
        List result = VradiService.getWikittyProxy().restore(Group.class, new ArrayList(groupsSet));
        Collections.sort(result, VradiComparators.GROUP_COMPARATOR);
        return result;
    }

    public static Set<String> findAllGroupsConcernedBySending(Sending sending) {
        HashSet<String> result = new HashSet<String>();
        if (sending != null) {
            Set<GroupForms> groupsForms = EmailDataHelper.findAllGroupsFormsConcernedBySending(sending);
            for (GroupForms gf : groupsForms) {
                if (gf == null) continue;
                result.add(gf.getGroup());
            }
        }
        return result;
    }

    protected static Set<GroupForms> findAllGroupsFormsConcernedBySending(Sending sending) {
        HashSet<GroupForms> result = new HashSet<GroupForms>();
        if (sending != null) {
            Set<String> groupFormsConcernedDeleted;
            Set<String> groupFormsConcerned = sending.getGroupForms();
            if (groupFormsConcerned != null) {
                WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
                List groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsConcerned));
                result.addAll(groupForms);
            }
            if ((groupFormsConcernedDeleted = sending.getDeletedGroupForms()) != null) {
                WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
                List groupFormsDeleted = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsConcernedDeleted));
                result.addAll(groupFormsDeleted);
            }
        }
        return result;
    }

    public static List<String> extractIds(Collection<? extends BusinessEntity> entities) {
        ArrayList<String> ids = new ArrayList<String>();
        if (entities == null) {
            return ids;
        }
        for (BusinessEntity businessEntity : entities) {
            if (businessEntity == null) continue;
            ids.add(businessEntity.getWikittyId());
        }
        return ids;
    }
}

