/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.FormViewUI;
import com.jurismarches.vradi.ui.email.SendingViewUI;
import com.jurismarches.vradi.ui.email.SessionViewUI;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

public enum EmailBeanConstant {
    GROUP(Group.class, null),
    USER(User.class, SendingViewUI.class),
    FORM(Form.class, FormViewUI.class),
    SESSION(Session.class, SessionViewUI.class);

    private static Log log;
    protected Class<? extends BusinessEntity> beanClass;
    protected Class<? extends EmailContentUI> uiClass;

    private EmailBeanConstant(Class<? extends BusinessEntity> beanClass, Class<? extends EmailContentUI> uiClass) {
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public Class<? extends BusinessEntity> getBeanClass() {
        return this.beanClass;
    }

    public Class<? extends EmailContentUI> getUIClass() {
        return this.uiClass;
    }

    public static EmailBeanConstant getConstantByBeanClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : EmailBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant;
        }
        return null;
    }

    public BusinessEntity getBean(VradiDataProvider provider, String id) {
        WikittyProxy proxy = provider.getWikittyProxy();
        return proxy.restore(this.beanClass, id);
    }

    public static Class<? extends EmailContentUI> getUIClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : EmailBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant.getUIClass();
        }
        return null;
    }

    public String decorate(Session currentSession, BusinessEntity bean) {
        String result = "";
        switch (this) {
            case GROUP: {
                Group group = this.cast(Group.class, bean);
                result = group.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, group) + ")";
                break;
            }
            case USER: {
                StringBuffer sendingBuffer = new StringBuffer();
                User user = this.cast(User.class, bean);
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                sendingBuffer.append(client.getName());
                sendingBuffer.append(" - ");
                sendingBuffer.append(user.getName());
                Sending sending = EmailDataHelper.getUserSending(currentSession, user.getWikittyId());
                if (sending != null) {
                    sendingBuffer.append(" [");
                    VradiConstants.SendingStatus status = VradiConstants.SendingStatus.getStatus((int)sending.getStatus());
                    sendingBuffer.append(status.getDescription());
                    sendingBuffer.append("] ");
                }
                sendingBuffer.append(" (");
                sendingBuffer.append(EmailDataHelper.getNbFormToSend(currentSession, user));
                sendingBuffer.append(")");
                result = sendingBuffer.toString();
                break;
            }
            case FORM: {
                Form form = this.cast(Form.class, bean);
                result = form.getObjet();
                break;
            }
            case SESSION: {
                Session session = this.cast(Session.class, bean);
                StringBuffer sessionBuffer = new StringBuffer();
                sessionBuffer.append(session.getNum());
                sessionBuffer.append(" - ");
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                sessionBuffer.append(format.format(session.getSessionDate()));
                VradiConstants.SessionStatus sessionStatus = VradiConstants.SessionStatus.getStatus((int)session.getStatus());
                if (sessionStatus != null) {
                    sessionBuffer.append(" [");
                    sessionBuffer.append(sessionStatus.getDescription());
                    sessionBuffer.append("]");
                } else {
                    log.warn((Object)("Cant find status for num : " + session.getStatus()));
                }
                result = sessionBuffer.toString();
            }
        }
        return result;
    }

    public String getToolTipText(BusinessEntity bean) {
        String result = null;
        switch (this) {
            case SESSION: {
                Session session = this.cast(Session.class, bean);
                String sessionLogs = session.getSessionLogs();
                if (sessionLogs == null || sessionLogs.isEmpty()) break;
                result = sessionLogs;
            }
        }
        return result;
    }

    protected <B extends BusinessEntity> B cast(Class<B> toCast, BusinessEntity bean) {
        return (B)bean;
    }

    static {
        log = LogFactory.getLog(EmailBeanConstant.class);
    }
}

