/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.models;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyI18n;

public class FieldSelectModel
implements Serializable {
    private static final Log log = LogFactory.getLog(FieldSelectModel.class);
    public static final String PROPERTY_NAME_VALUE = "nameValue";
    public static final String PROPERTY_DESC_VALUE = "descValue";
    public static final String PROPERTY_TRADUCTION = "traduction";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_POSITION = "position";
    public static final String PROPERTY_UP_OR_DOWN = "upOrDown";
    private static final long serialVersionUID = 1L;
    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected String nameValue;
    protected String fqFieldName;
    protected String descValue;
    protected FieldTypeEnum type;
    protected Integer position;
    protected Boolean upOrDown = null;
    protected String traduction;
    protected WikittyI18n wikittyI18n;

    public FieldSelectModel() {
        this(null);
    }

    public FieldSelectModel(Integer position) {
        this(null, null, null, position);
    }

    public FieldSelectModel(String fqFieldName, FieldType fieldType, WikittyI18n wikittyI18n, Integer position) {
        this.wikittyI18n = wikittyI18n;
        this.fqFieldName = fqFieldName;
        if (fqFieldName != null) {
            this.nameValue = fqFieldName.indexOf(46) != -1 ? WikittyUtil.getFieldNameFromFQFieldName((String)fqFieldName) : fqFieldName;
        }
        this.descValue = VradiHelper.getFieldTypeDescription(fieldType);
        this.type = FieldTypeEnum.valueOf(fieldType);
        this.position = position;
        this.traduction = VradiHelper.getTraduction(wikittyI18n, fqFieldName);
    }

    public void update(FieldSelectModel model) {
        this.setNameValue(model.getNameValue());
        this.setFqFieldName(model.getFqFieldName());
        this.setType(model.getType());
        this.setDescValue(model.getDescValue());
        this.setPosition(model.getPosition());
        this.wikittyI18n = model.getWikittyI18n();
        this.setTraduction(VradiHelper.getTraduction(this.wikittyI18n, this.fqFieldName));
    }

    public String getNameValue() {
        return this.nameValue;
    }

    public void setNameValue(String value) {
        String oldValue = this.nameValue;
        this.nameValue = value;
        this.propertyChange.firePropertyChange(PROPERTY_NAME_VALUE, oldValue, value);
    }

    public String getFqFieldName() {
        return this.fqFieldName;
    }

    public void setFqFieldName(String fqFieldNames) {
        this.fqFieldName = fqFieldNames;
    }

    public String getDescValue() {
        return this.descValue;
    }

    public void setDescValue(String value) {
        String oldValue = this.descValue;
        this.descValue = value;
        this.propertyChange.firePropertyChange(PROPERTY_DESC_VALUE, oldValue, value);
    }

    public FieldTypeEnum getType() {
        return this.type;
    }

    public void setType(FieldTypeEnum value) {
        FieldTypeEnum oldValue = this.type;
        this.type = value;
        this.propertyChange.firePropertyChange(PROPERTY_TYPE, (Object)oldValue, (Object)value);
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer value) {
        Integer oldValue = this.position;
        this.position = value;
        this.propertyChange.firePropertyChange(PROPERTY_POSITION, oldValue, value);
    }

    public Boolean isUpOrDown() {
        return this.upOrDown;
    }

    public void setUpOrDown(Boolean value) {
        Boolean oldValue = this.upOrDown;
        this.upOrDown = value;
        this.propertyChange.firePropertyChange(PROPERTY_UP_OR_DOWN, oldValue, value);
    }

    public String getTraduction() {
        String result = null;
        if (this.traduction != null && !this.traduction.equals(this.nameValue)) {
            result = this.traduction;
        }
        return result == null ? "" : result;
    }

    public void setTraduction(String traduction) {
        String old = this.traduction;
        this.traduction = traduction;
        if (this.wikittyI18n != null) {
            this.wikittyI18n.setTranslation(VradiHelper.getCurrentLocale().getLanguage(), this.nameValue, traduction);
        }
        this.propertyChange.firePropertyChange(PROPERTY_TRADUCTION, old, traduction);
    }

    public WikittyI18n getWikittyI18n() {
        return this.wikittyI18n;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(propertyName, listener);
    }
}

