/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.loadors.ClientUsersNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.ClientsAndUsersNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.FormTypeNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.GroupsNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.StreamNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.helpers.VradiTreeHelper;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;

public abstract class AdminNavigationTreeHelper<C extends BusinessEntity>
extends VradiTreeHelper<C> {
    private static final Log log = LogFactory.getLog(AdminNavigationTreeHelper.class);

    public AdminNavigationTreeHelper(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
    }

    public TreeModel createTreeModel() {
        VradiTreeNode root = new VradiTreeNode(String.class, "Root node", null, null);
        VradiTreeNode child = this.createNode();
        root.add(child);
        DefaultTreeModel model = this.createModel(root, new Object[0]);
        root.populateChilds(this.getBridge(), this.getDataProvider());
        this.registerLoadedIds(child);
        return model;
    }

    public abstract VradiTreeNode createNode();

    public VradiTreeNode getParentSelectedCategoryNode(String categoryName) {
        return AdminNavigationTreeHelper.getParentCategoryNode(this.getSelectedNode(), categoryName);
    }

    public static VradiTreeNode getParentCategoryNode(VradiTreeNode node, String categoryName) {
        if (node == null) {
            return null;
        }
        if (node.getId().contains(categoryName)) {
            return node;
        }
        return AdminNavigationTreeHelper.getParentCategoryNode((VradiTreeNode)node.getParent(), categoryName);
    }

    public VradiTreeNode getParentSelectedNode(Class type) {
        return AdminNavigationTreeHelper.getParentNode(this.getSelectedNode(), type);
    }

    public static VradiTreeNode getParentNode(VradiTreeNode node, Class type) {
        if (node == null) {
            return null;
        }
        if (type.equals(node.getInternalClass())) {
            return node;
        }
        return AdminNavigationTreeHelper.getParentNode((VradiTreeNode)node.getParent(), type);
    }

    public void createNode(Class<? extends NavTreeNodeChildLoador<String, ?, VradiTreeNode>> nodeLoadorsClass, String categoryName) {
        this.createNode(nodeLoadorsClass, categoryName, null, false);
    }

    public void createNode(Class<? extends NavTreeNodeChildLoador<String, ?, VradiTreeNode>> nodeLoadorsClass, String categoryName, String id, boolean select) {
        VradiTreeNode node = this.findNode(this.getRootNode(), id);
        if (node == null) {
            VradiTreeNode parentNode = this.findNode(this.getRootNode(), categoryName);
            if (parentNode == null) {
                return;
            }
            node = (VradiTreeNode)((NavTreeNodeChildLoador)AdminNavigationTreeHelper.getChildLoador(nodeLoadorsClass)).createNode((Object)id, (NavDataProvider)this.getDataProvider());
            this.insertNode((NavNode)parentNode, (NavNode)node);
        }
        if (select && (this.getSelectedNode() == null || !this.getSelectedNode().getId().equals(node.getId()))) {
            this.selectNode(node);
        }
    }

    public void createAndSelectClientNode(String clientId) {
        this.createClientNode(clientId, true);
    }

    public void createClientNode(String clientId, boolean select) {
        this.createNode(ClientsAndUsersNodeLoadors.class, AdminBeanConstant.CLIENT.getCategoryName(), clientId, select);
    }

    public void createAndSelectGroupNode(String groupId) {
        this.createGroupNode(groupId, true);
    }

    public void createGroupNode(String groupId, boolean select) {
        this.createNode(GroupsNodeLoadors.class, AdminBeanConstant.GROUP.getCategoryName(), groupId, select);
    }

    public void createAndSelectUserNode(String userId, String clientId) {
        this.createUserNode(userId, clientId, true);
    }

    public void createUserNode(String userId, boolean select) {
        this.createUserNode(userId, null, select);
    }

    public void createUserNode(String userId, String clientId, boolean select) {
        if (clientId == null) {
            User user = (User)VradiService.getWikittyProxy().restore(User.class, userId);
            if (user == null) {
                return;
            }
            clientId = user.getClient();
        }
        this.createNode(ClientUsersNodeLoadors.class, clientId + AdminBeanConstant.USER.getCategoryName(), userId, select);
    }

    public void createAndSelectFormTypeNode(String extensionId) {
        this.createFormTypeNode(extensionId, true);
    }

    public void createFormTypeNode(String extensionId, boolean select) {
        this.createNode(FormTypeNodeLoadors.class, AdminBeanConstant.FORM_TYPE.getCategoryName(), extensionId, select);
    }

    public void createAndSelectStreamNode(String streamId) {
        this.createStreamNode(streamId, true);
    }

    public void createStreamNode(String streamId, boolean select) {
        this.createNode(StreamNodeLoadors.class, AdminBeanConstant.XML_STREAM.getCategoryName(), streamId, select);
    }

    public void reSelectCategory(VradiTreeNode node) {
        String id = ((VradiTreeNode)node.getParent()).getId();
        log.debug((Object)("Try to load subcategory for node : " + id));
        this.selectNode(new String[]{id, node.getId()});
    }

    public Client getClientSelected() {
        VradiTreeNode clientNode = this.getParentSelectedNode(Client.class);
        if (clientNode == null) {
            return null;
        }
        return (Client)VradiService.getWikittyProxy().restore(Client.class, clientNode.getId());
    }
}

