/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.bean;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.decorator.MultiJXPathDecorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.nuiton.i18n.I18n;

public class BeanUIUtil {
    public static final String DEFAULT_POPUP_LABEL = I18n.n_((String)"bean.popup.label");
    public static final String DEFAULT_SELECTED_TOOLTIP = I18n.n_((String)"bean.sort.on");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = I18n.n_((String)"bean.sort.off");
    private static final List<String> COMBO_BOX_ACTIONS = Collections.unmodifiableList(Arrays.asList("selectNext", "selectNext2", "selectPrevious", "selectPrevious2", "pageDownPassThrough", "pageUpPassThrough", "homePassThrough", "endPassThrough"));

    public static ObjectToStringConverter newDecoratedObjectToStringConverter(final Decorator<?> decorator) {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object item) {
                return item instanceof String ? (String)item : (item == null ? "" : decorator.toString(item));
            }
        };
    }

    public static void decorate(JComboBox combo, ObjectToStringConverter convertor) {
        combo.putClientProperty("oldEditor", combo.getEditor());
        combo.putClientProperty("oldDocument", combo.getEditor().getEditorComponent());
        AutoCompleteDecorator.decorate((JComboBox)combo, (ObjectToStringConverter)convertor);
    }

    public static void undecorate(JComboBox comboBox, Document originalDocument) {
        comboBox.setEditable(false);
        Component c = comboBox.getEditor().getEditorComponent();
        JTextComponent editorComponent = (JTextComponent)c;
        editorComponent.setDocument(originalDocument);
        editorComponent.setText(null);
        ComboBoxEditor oldEditor = (ComboBoxEditor)comboBox.getClientProperty("oldEditor");
        if (editorComponent.getDocument() instanceof AutoCompleteDocument) {
            AutoCompleteDocument doc = (AutoCompleteDocument)editorComponent.getDocument();
            if (doc.isStrictMatching()) {
                ActionMap map = comboBox.getActionMap();
                for (String key : COMBO_BOX_ACTIONS) {
                    map.put(key, null);
                }
            }
            for (PropertyChangeListener l : comboBox.getPropertyChangeListeners("editor")) {
                if (!l.getClass().getName().contains("AutoComplete")) continue;
                comboBox.removePropertyChangeListener("editor", l);
            }
            for (PropertyChangeListener l : comboBox.getPropertyChangeListeners("enabled")) {
                if (!l.getClass().getName().contains("AutoComplete")) continue;
                comboBox.removePropertyChangeListener("enabled", l);
            }
            AutoCompleteComboBoxEditor editor = (AutoCompleteComboBoxEditor)comboBox.getEditor();
            comboBox.setEditor(oldEditor);
            for (KeyListener keyListener : editorComponent.getKeyListeners()) {
                if (!keyListener.getClass().getName().contains("AutoComplete")) continue;
                editorComponent.removeKeyListener(keyListener);
                break;
            }
            BeanUIUtil.undecorate(editorComponent, originalDocument);
            for (EventListener eventListener : comboBox.getActionListeners()) {
                if (!(eventListener instanceof ComboBoxAdaptor)) continue;
                comboBox.removeActionListener((ActionListener)eventListener);
                break;
            }
        }
    }

    static void undecorate(JTextComponent textComponent, Document originalDocument) {
        Document doc = textComponent.getDocument();
        if (doc instanceof AutoCompleteDocument) {
            InputMap map = textComponent.getInputMap();
            while (map.getParent() != null) {
                InputMap parent = map.getParent();
                if (parent.getClass().getName().contains("AutoComplete")) {
                    map.setParent(parent.getParent());
                }
                map = parent;
            }
            textComponent.getActionMap().put("nonstrict-backspace", null);
            for (FocusListener l : textComponent.getFocusListeners()) {
                if (!l.getClass().getName().contains("AutoComplete")) continue;
                textComponent.removeFocusListener(l);
                break;
            }
            textComponent.setDocument(originalDocument);
        }
    }

    public static <O> MultiJXPathDecorator<O> createDecorator(JXPathDecorator<O> decorator) {
        String separatorReplacement;
        String separator;
        if (decorator == null) {
            throw new NullPointerException("can not have a null decorator as parameter");
        }
        if (decorator instanceof MultiJXPathDecorator) {
            separator = ((MultiJXPathDecorator)decorator).getSeparator();
            separatorReplacement = ((MultiJXPathDecorator)decorator).getSeparatorReplacement();
        } else {
            separator = "??" + new Date().getTime();
            separatorReplacement = " - ";
        }
        return DecoratorUtils.newMultiJXPathDecorator((Class)decorator.getInternalClass(), (String)decorator.getInitialExpression(), (String)separator, (String)separatorReplacement);
    }

    public static abstract class PopupHandler
    implements Runnable {
        public static final Log log = LogFactory.getLog(PopupHandler.class);

        public abstract JPopupMenu getPopup();

        public abstract JComponent getInvoker();

        @Override
        public void run() {
            this.updatePopup();
            Dimension dim = this.getPopup().getPreferredSize();
            JComponent invoker = this.getInvoker();
            this.getPopup().show(invoker, (int)(invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
        }

        public void togglePopup() {
            boolean newValue;
            boolean bl = newValue = !this.getPopup().isVisible();
            if (log.isTraceEnabled()) {
                log.trace((Object)newValue);
            }
            if (!newValue) {
                if (this.getPopup() != null) {
                    this.getPopup().setVisible(false);
                }
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        protected void updatePopup() {
            this.getPopup().pack();
        }

        protected void preparePopup(String selectedTip, String notSelectedTip, String i18nPrefix, String title, ButtonGroup indexes, JLabel popupLabel, AbstractButton sortUp, AbstractButton sortDown, MultiJXPathDecorator<?> decorator) {
            if (selectedTip == null) {
                selectedTip = DEFAULT_SELECTED_TOOLTIP;
            }
            if (notSelectedTip == null) {
                notSelectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
            }
            JPopupMenu popup = this.getPopup();
            int max = decorator.getNbContext();
            for (int i = 0; i < max; ++i) {
                String property = i18nPrefix + decorator.getProperty(i);
                String propertyI18n = I18n._((String)property);
                JRadioButtonMenuItem button = new JRadioButtonMenuItem(propertyI18n);
                button.putClientProperty("$buttonGroup", indexes);
                button.putClientProperty("$value", i);
                popup.add(button);
                if (selectedTip != null) {
                    button.putClientProperty("$selected.toolTipText", I18n._((String)selectedTip, (Object[])new Object[]{propertyI18n}));
                }
                if (notSelectedTip != null) {
                    button.putClientProperty("$not.selected.toolTipText", I18n._((String)notSelectedTip, (Object[])new Object[]{propertyI18n}));
                }
                button.setSelected(false);
                indexes.add(button);
            }
            if (title == null) {
                title = DEFAULT_POPUP_LABEL;
                Class internalClass = decorator.getInternalClass();
                String beanI18nKey = internalClass == null ? I18n.n_((String)"bean.unknown.type") : i18nPrefix + Introspector.decapitalize(internalClass.getSimpleName());
                String beanI18n = I18n._((String)beanI18nKey);
                title = I18n._((String)title, (Object[])new Object[]{beanI18n});
            } else {
                title = I18n._((String)title);
            }
            sortDown.putClientProperty("$selected.toolTipText", I18n._((String)"bean.sort.down.tip"));
            sortDown.putClientProperty("$not.selected.toolTipText", I18n._((String)"bean.sort.down.toSelect.tip"));
            sortUp.putClientProperty("$selected.toolTipText", I18n._((String)"bean.sort.up.tip"));
            sortUp.putClientProperty("$not.selected.toolTipText", I18n._((String)"bean.sort.up.toSelect.tip"));
            popupLabel.setText(title);
            this.getPopup().setLabel(title);
            this.getPopup().invalidate();
        }
    }
}

