/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.function.FloatFieldSource;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatField
extends FieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.restrictProps(6144);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return new SortField(field.name, 5, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field) {
        return new FloatFieldSource(field.name);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeFloat(name, f.stringValue());
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String s = f.stringValue();
        if (s.length() == 0) {
            writer.writeNull(name);
            return;
        }
        try {
            float fval = Float.parseFloat(s);
            writer.writeFloat(name, fval);
        }
        catch (NumberFormatException e) {
            writer.writeStr(name, s, true);
        }
    }

    @Override
    public Float toObject(Fieldable f) {
        return Float.valueOf(this.toExternal(f));
    }
}

