/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Config;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInfo {
    public final String name;
    public final String className;
    public final String type;
    public final NamedList initArgs;
    public final Map<String, String> attributes;
    public final List<PluginInfo> children;

    public PluginInfo(String type, Map<String, String> attrs, NamedList initArgs, List<PluginInfo> children) {
        this.type = type;
        this.name = attrs.get("name");
        this.className = attrs.get("class");
        this.initArgs = initArgs;
        this.attributes = Collections.unmodifiableMap(attrs);
        this.children = children == null ? Collections.emptyList() : Collections.unmodifiableList(children);
    }

    public PluginInfo(Node node, String err, boolean requireName, boolean requireClass) {
        this.type = node.getNodeName();
        this.name = DOMUtil.getAttr((Node)node, (String)"name", (String)(requireName ? err : null));
        this.className = DOMUtil.getAttr((Node)node, (String)"class", (String)(requireClass ? err : null));
        this.initArgs = DOMUtil.childNodesToNamedList((Node)node);
        this.attributes = Collections.unmodifiableMap(DOMUtil.toMap((NamedNodeMap)node.getAttributes()));
        this.children = this.loadSubPlugins(node);
    }

    private List<PluginInfo> loadSubPlugins(Node node) {
        ArrayList<PluginInfo> children = null;
        try {
            NodeList nodes = (NodeList)Config.xpathFactory.newXPath().evaluate("*[@class]", node, XPathConstants.NODESET);
            if (nodes.getLength() > 0) {
                children = new ArrayList<PluginInfo>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    PluginInfo pluginInfo = new PluginInfo(nodes.item(i), null, false, false);
                    if (!pluginInfo.isEnabled()) continue;
                    children.add(pluginInfo);
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return children == null ? Collections.emptyList() : Collections.unmodifiableList(children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.type != null) {
            sb.append("type = " + this.type + ",");
        }
        if (this.name != null) {
            sb.append("name = " + this.name + ",");
        }
        if (this.className != null) {
            sb.append("class = " + this.className + ",");
        }
        if (this.initArgs.size() > 0) {
            sb.append("args = " + this.initArgs);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isEnabled() {
        String enable = this.attributes.get("enable");
        return enable == null || Boolean.parseBoolean(enable);
    }

    public boolean isDefault() {
        return Boolean.parseBoolean(this.attributes.get("default"));
    }

    public List<PluginInfo> getChildren(String type) {
        if (this.children.isEmpty()) {
            return this.children;
        }
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        for (PluginInfo child : this.children) {
            if (!type.equals(child.type)) continue;
            result.add(child);
        }
        return result;
    }
}

