/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FormTypeModel.java 1808 2010-11-25 14:27:29Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/models/FormTypeModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.VradiExtensionsListener;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.WikittyExtension;

import javax.swing.*;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @author letellier
 */
public class FormTypeModel extends DefaultComboBoxModel implements VradiExtensionsListener {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(FormTypeModel.class);

    protected boolean firstNull = false;

    public FormTypeModel(boolean firstNull) {
        this.firstNull = firstNull;

        init();

        // register each tree on wikitty service
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    public void init() {

        List<WikittyExtension> formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        } catch (VradiException eee) {
            log.error("Cant get all forms types", eee);
            ErrorDialogUI.showError(eee);
        }
        removeAllElements();

        // Sort
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);
        for (WikittyExtension formType : formTypes) {
            addElement(formType);
        }

        if (firstNull) {
            setSelectedItem(null);
        }
    }

    @Override
    public int getSize() {
        if (firstNull){
            return super.getSize() + 1;
        }
        return super.getSize();
    }

    @Override
    public Object getElementAt(int index) {
        if (firstNull){
            if (index == 0){
                return null;
            }

            return super.getElementAt(index - 1);
        }
        return super.getElementAt(index);
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        init();
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        init();
    }
}
