/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.regex.Matcher;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class XmlStreamConfigUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.XmlStream bean;
    protected javax.swing.JComboBox hourDays;
    protected javax.swing.JComboBox minuteDays;
    protected XmlStreamConfigUI xmlStreamConfigUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ComboBoxModel minutesModel;
    protected ComboBoxModel hoursModel;
    protected ComboBoxModel daysModel;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getBean() != null) {
                
    
                    // Parse la valeur ImportTime du bean XmlStream courant et
                    // initialise correctement les differents panel.
                    //
                    // Dans le cas ou le pattern ne match pas, la valeur par defaut
                    // est celle des services (à savoir, tous les 1 jour, à minuit).
                    //
                    String xmlStringImportTime = bean.getImportTime();
    
                    if (xmlStringImportTime != null && !xmlStringImportTime.isEmpty()) {
                        Matcher matcher = VradiConstants.XML_STREAM_IMPORT_TIME.matcher(xmlStringImportTime);
            
                        if (matcher.find()) {
                            // selection des heures
                            hourDays.setSelectedItem(Integer.valueOf(matcher.group(1)));
                            // selection de la minutes
                            minuteDays.setSelectedItem(Integer.valueOf(matcher.group(2)));
                        }
                    }
                } else {
                    // clear UI
                    hourDays.setSelectedItem(0);
                    minuteDays.setSelectedItem(0);;
                }
            }
        });
    }
    
    /**
     * Set import time value into bean.
     */
    protected void setImportTimeValue() {
        if (bean != null) {
            String importTime = null;
            importTime = hourDays.getSelectedItem().toString() + ":" + minuteDays.getSelectedItem().toString();
            bean.setImportTime(importTime);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public XmlStreamConfigUI() {
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__hourDays(java.awt.event.ActionEvent event) {
        setImportTimeValue();
    }

    public void doActionPerformed__on__minuteDays(java.awt.event.ActionEvent event) {
        setImportTimeValue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.XmlStream getBean() {
        return bean;
    }

    public javax.swing.JComboBox getHourDays() {
        return hourDays;
    }

    public javax.swing.JComboBox getMinuteDays() {
        return minuteDays;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.XmlStream newValue) {
        com.jurismarches.vradi.entities.XmlStream oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToXmlStreamConfigUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0);
        add(hourDays);
        add($JLabel1);
        add(minuteDays);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createHourDays() {
        $objectMap.put("hourDays", hourDays = new javax.swing.JComboBox());
        
        hourDays.setName("hourDays");
        hourDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hourDays"));
    }

    protected void createMinuteDays() {
        $objectMap.put("minuteDays", minuteDays = new javax.swing.JComboBox());
        
        minuteDays.setName("minuteDays");
        minuteDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__minuteDays"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToXmlStreamConfigUI();
        
        // apply 6 property setters
        hourDays.setModel(UIHelper.getHourModel());
        hourDays.setRenderer(UIHelper.get2DigitsRenderer());
        hourDays.setSelectedItem(0);
        minuteDays.setModel(UIHelper.getMinuteModel());
        minuteDays.setRenderer(UIHelper.get2DigitsRenderer());
        minuteDays.setSelectedItem(0);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("xmlStreamConfigUI", this);
        createBean();
        minutesModel = new DefaultComboBoxModel(new Object[]{15, 30, 45});
        hoursModel = UIHelper.getNumberComboBoxModel(1, 24);
        daysModel = UIHelper.getNumberComboBoxModel(1, 31);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.config.load"));
        createHourDays();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.common.timeseparator"));
        createMinuteDays();
        // inline creation of xmlStreamConfigUI
        setName("xmlStreamConfigUI");
        
        $completeSetup();
    }

}