/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionHandler;
import com.jurismarches.vradi.ui.offer.widgets.MultipleSelectionPane;
import java.awt.Desktop;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AttachmentFileHandler
extends MultipleSelectionHandler<File> {
    private static final Log log = LogFactory.getLog(AttachmentFileHandler.class);

    public AttachmentFileHandler(MultipleSelectionPane ui) {
        super(ui);
        ui.setLbl(I18n._((String)"vradi.offerEdit.attachedfile"));
    }

    @Override
    public void init() {
        Set attachments = this.getBean().getAttachments();
        this.fillList(attachments);
    }

    @Override
    public void add() {
        File file = this.getHandler().addAttachmentFile(this.ui, this.getBean());
        this.addToList(file, file.getName());
    }

    @Override
    public void remove() {
        List<String> filesNames = this.getHandler().removeAttachmentFile(this.getBean(), this.getSelectedInList());
        this.removeFromList(filesNames);
    }

    @Override
    public void openSelected(String selected) {
        try {
            File file = VradiService.getFileService().downloadFormAttachment(selected, this.getBean().getWikittyId());
            Desktop.getDesktop().open(file);
        }
        catch (Exception eee) {
            log.error((Object)("Error on download file : " + selected), (Throwable)eee);
            this.getHandler().fileNotFound(selected);
        }
    }
}

