/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.thesaurus;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.thesaurus.*;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusSelectionManager;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_MODEL = "thesaurus.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_TOOL_TIP_TEXT = "$JLabel0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTree thesaurus;
    protected javax.swing.JList thesaurusSelected;
    protected ThesaurusUI thesaurusUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected DefaultListModel thesaurusSelectedModel;
    protected ThesaurusSelectionManager manager;
    protected ThesaurusTreeHelper helper;
    protected boolean deletable;
    
    
    public  ThesaurusUI(JAXXContext parentContext, ThesaurusSelectionManager manager, ThesaurusTreeHelper helper, boolean deletable) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.deletable = deletable;
        this.helper = helper;
        this.manager = manager;
    $initialize();
    }
    
    public OfferEditUI getParentUI(){
        return getParentContainer(OfferEditUI.class);
    }
    
    protected ThesaurusHandler getHandler() {
        return getContextValue(ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    void $afterCompleteSetup() {
    
        // Remove on double click
        thesaurusSelected.addMouseListener(new MouseAdapter(){
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Thesaurus toUnselect = (Thesaurus)thesaurusSelected.getSelectedValue();
                    manager.tryToUnSelect(toUnselect);
                }
            }
        });
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                boolean isSelected = path != null;
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
    //                JMenuItem menuAddCriteria = new JMenuItem();
    //                menuAddCriteria.setText(_("vradi.menu.addCriteria"));
    //                menuAddCriteria.addActionListener(new ActionListener() {
    
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addCriteriaSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddCriteria);
    
    //                JMenuItem menuAddColumns = new JMenuItem();
    //                menuAddColumns.setText(_("vradi.menu.addColumns"));
    //                menuAddColumns.addActionListener(new ActionListener() {
    //
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addColumnSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddColumns);
    
                    if (isSelected){
                        JMenuItem menuAddThesaurus = new JMenuItem();
                        menuAddThesaurus.setText(_("vradi.menu.addThesaurus"));
                        menuAddThesaurus.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                addThesaurusSelected(getPathSelected(mouseEvent));
                            }
                        });
                        popup.add(menuAddThesaurus);
                    }
                    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        TreeSelectionListener selectionListener = new TreeSelectionListener() {
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                thsaurusSelected();
            }
        };
        thesaurus.addTreeSelectionListener(selectionListener);
    
        // Expends root
        thesaurus.expandRow(0);
    
        // Override default selection model to enable one click selection
        thesaurus.setSelectionModel(new DefaultTreeSelectionModel() {
    
            @Override
            public void setSelectionPath(TreePath path) {
                TreePath[] treePaths = getSelectionPaths();
                if (treePaths == null || !Arrays.asList(treePaths).contains(path)) {
                    addSelectionPath(path);
                } else {
                    removeSelectionPath(path);
                }
            }
        });
    
        // If not root thesaurusUI
        if (deletable) {
            manager.registerTreeHelper(helper, thesaurus);
        } else {
            manager.registerRootTreeHelper(helper, thesaurus);
        }
        
        // Tooltip is not active without this code...
        javax.swing.ToolTipManager.sharedInstance().registerComponent(thesaurus);
    }
    
    public DefaultListModel getThesaurusSelectedModel(){
        return thesaurusSelectedModel;
    }
    
    protected void thsaurusSelected(){
        TreePath[] treePaths = thesaurus.getSelectionPaths();
        jaxx.runtime.JAXXUtil.assignment(thesaurusSelectedModel = new DefaultListModel(), "thesaurusSelectedModel", com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusUI.this);
        if (treePaths != null){
            for (TreePath path : treePaths){
                VradiTreeNode selected = (VradiTreeNode)path.getLastPathComponent();
                if (selected.getInternalClass().equals(Thesaurus.class)) {
                    Thesaurus thesaurusSelected = ThesaurusDataHelper.restoreThesaurus(selected.getId());
                    thesaurusSelectedModel.addElement(thesaurusSelected);
                }
    
            }
        }
        thesaurusSelected.setModel(thesaurusSelectedModel);
    }
    
    protected TreePath getPathSelected(MouseEvent mouseEvent){
        JTree tree = (JTree) mouseEvent.getSource();
    
        // Recuperation du path selectionne
        TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
        return path;
    }
    
    protected void addCriteriaSelected(TreePath path){
        log.debug("addCriteriaSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addCriteria(this, helper, path);
    }
    
    protected void addThesaurusSelected(TreePath path){
        log.debug("addThesaurusSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().newThesaurusUI(this, manager, path);
    }
    
    protected void addColumnSelected(TreePath path){
        log.debug("addColumnSelected " + path);
        // Ajout dune nouvelle column
    //    getHandler().addColumn(this, helper, path);
    }
    
    protected String getRootNamePath(){
        String path = getHandler().getNamePath(helper.getRootNode());
        return StringUtils.abbreviate(path, path.length() - 20, 23);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusUI() {
        $initialize();
    }

    public ThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().closeThesaurus(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public javax.swing.JList getThesaurusSelected() {
        return thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setBorderPainted(false);
        $JButton0.setFocusPainted(false);
        $JButton0.setHorizontalTextPosition(0);
        $JButton0.setOpaque(true);
        $JButton0.setVerticalAlignment(0);
        $JButton0.setVerticalTextPosition(0);
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        
        thesaurus.setName("thesaurus");
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = new javax.swing.JList());
        
        thesaurusSelected.setName("thesaurusSelected");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurusSelected);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(thesaurus);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JLabel0.setText(_(getRootNamePath()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("closeTab"));
        $JButton0.setSize(new Dimension(16, 16));
        thesaurusSelected.setCellRenderer(new ThesaurusHighlighter());
        thesaurus.setCellRenderer(new ThesaurusHighlighter());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusUI", this);
        thesaurusSelectedModel = new DefaultListModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        create$JButton0();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurusSelected();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createThesaurus();
        // inline creation of thesaurusUI
        setName("thesaurusUI");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TOOL_TIP_TEXT, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    $JLabel0.setToolTipText(_(getHandler().getNamePath(helper.getRootNode())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"deletable") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(deletable);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setModel(helper.createTreeModel());
                }
            }
        });
    }

}