/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FieldSelectUI extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODIFIED = "modified";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLAZZ_COMBO_SELECTED_ITEM = "clazzCombo.selectedItem";
    public static final String BINDING_DESC_FIELD_TEXT = "descField.text";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.FieldSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.admin.models.FieldSelectModel bean;
    protected javax.swing.JComboBox clazzCombo;
    protected javax.swing.JTextField descField;
    protected javax.swing.JButton down;
    protected java.lang.Boolean modified;
    protected javax.swing.JTextField nameField;
    protected javax.swing.JButton remove;
    protected FieldSelectUI requestSelectUI = this;
    protected javax.swing.JButton up;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    public void updateBean(FieldSelectModel model) {
        bean.update(model);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }
    
    void $afterCompleteSetup() {
        getContextValue(SwingValidatorMessageTableModel.class,"errorTable").registerValidator(validator);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FieldSelectUI() {
        $initialize();
    }

    public FieldSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clazzCombo(java.awt.event.ActionEvent event) {
        bean.setType((FieldTypeEnum) clazzCombo.getSelectedItem()); setModified(true);
    }

    public void doActionPerformed__on__down(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(false); log.debug(bean.getNameValue() + " : " + bean.isUpOrDown()); setModified(null);
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(null); setModified(null);
    }

    public void doActionPerformed__on__up(java.awt.event.ActionEvent event) {
        bean.setUpOrDown(true); log.debug(bean.getNameValue() + " : " + bean.isUpOrDown()); setModified(null);
    }

    public void doKeyReleased__on__descField(java.awt.event.KeyEvent event) {
        bean.setDescValue(descField.getText()); setModified(true);
    }

    public void doKeyReleased__on__nameField(java.awt.event.KeyEvent event) {
        bean.setNameValue(nameField.getText().trim()); setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.models.FieldSelectModel getBean() {
        return bean;
    }

    public javax.swing.JComboBox getClazzCombo() {
        return clazzCombo;
    }

    public javax.swing.JTextField getDescField() {
        return descField;
    }

    public javax.swing.JButton getDown() {
        return down;
    }

    public java.lang.Boolean getModified() {
        return modified;
    }

    public javax.swing.JTextField getNameField() {
        return nameField;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getUp() {
        return up;
    }

    public java.lang.Boolean isModified() {
        return modified !=null && modified;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModified(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.modified;
        this.modified = newValue;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("descValue", descField);
        validator.setFieldRepresentation("nameValue", nameField);
        validator.setFieldRepresentation("type", clazzCombo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(descField), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(clazzCombo), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(up, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(down, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(bean);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.ui.admin.models.FieldSelectModel());
    }

    protected void createClazzCombo() {
        $objectMap.put("clazzCombo", clazzCombo = new javax.swing.JComboBox());
        
        clazzCombo.setName("clazzCombo");
        clazzCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clazzCombo"));
    }

    protected void createDescField() {
        $objectMap.put("descField", descField = new javax.swing.JTextField());
        
        descField.setName("descField");
        descField.setColumns(15);
        descField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descField"));
    }

    protected void createDown() {
        $objectMap.put("down", down = new javax.swing.JButton());
        
        down.setName("down");
        down.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__down"));
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new javax.swing.JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new javax.swing.JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createUp() {
        $objectMap.put("up", up = new javax.swing.JButton());
        
        up.setName("up");
        up.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__up"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel >(com.jurismarches.vradi.ui.admin.models.FieldSelectModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        addChildrenToValidator();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        clazzCombo.setModel(getHandler().getTypesModel());
        clazzCombo.setRenderer(UIHelper.getTranslationListCellRenderer());
        up.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowUp"));
        down.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("arrowDown"));
        remove.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("requestSelectUI", this);
        createBean();
        createModified();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.name"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminField.desc"));
        createDescField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminField.type"));
        createClazzCombo();
        createUp();
        createDown();
        createRemove();
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("nameValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(nameField, bean.getNameValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("nameValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("descValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(descField, bean.getDescValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("descValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLAZZ_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    clazzCombo.setSelectedItem(bean.getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("type", this);
                }
            }
        });
    }

}