/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.admin.renderers.JListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.JListCellEditor;
import com.jurismarches.vradi.ui.task.ProgressBarUI;
import java.awt.*;
import java.awt.CardLayout;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminXmlStreamUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<XmlStream> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_XML_STREAM_UI_ENABLED = "adminXmlStreamUI.enabled";
    public static final String BINDING_CREATE_FORMS_ENABLED = "createForms.enabled";
    public static final String BINDING_CREATE_XML_STREAM_ENABLED = "createXmlStream.enabled";
    public static final String BINDING_FORM_TYPE_COMBO_SELECTED_ITEM = "formTypeCombo.selectedItem";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATE_URL_ENABLED = "validateUrl.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_WEB_HARVEST_STREAM_URL_TEXT = "webHarvestStreamUrl.text";
    public static final String BINDING_XML_STREAM_CONFIG_BEAN = "xmlStreamConfig.bean";
    public static final String BINDING_XML_STREAM_NAME_TEXT = "xmlStreamName.text";
    public static final String BINDING_XML_STREAM_URL_TEXT = "xmlStreamUrl.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_SIZE = "$JLabel0.size";
    private static final String BINDING_$JLABEL1_SIZE = "$JLabel1.size";
    private static final String BINDING_$JLABEL2_SIZE = "$JLabel2.size";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminXmlStreamForm;
    protected AdminXmlStreamUI adminXmlStreamUI = this;
    protected com.jurismarches.vradi.entities.XmlStream bean;
    protected javax.swing.JPanel cards;
    protected javax.swing.JButton createForms;
    protected javax.swing.JButton createWebHarvestStream;
    protected javax.swing.JButton createXmlStream;
    protected com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel fieldsModel;
    protected org.jdesktop.swingx.JXTable fieldsTable;
    protected javax.swing.JComboBox formTypeCombo;
    protected javax.swing.ComboBoxModel formTypeSelectionModel;
    protected javax.swing.JLabel lblName;
    protected javax.swing.JButton openWebHarvestEditor;
    protected javax.swing.JButton openWebHarvestScript;
    protected javax.swing.JLabel title;
    protected javax.swing.JButton validateUrl;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.XmlStream > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JComboBox webHarvestScript;
    protected javax.swing.JTextField webHarvestStreamUrl;
    protected com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI xmlStreamConfig;
    protected javax.swing.JTextField xmlStreamName;
    protected javax.swing.JLabel xmlStreamPreview;
    protected javax.swing.JButton xmlStreamSite;
    protected javax.swing.JTextField xmlStreamUrl;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    final static String XML_STREAM_PANEL = "vradi.adminXmlStream.xmlPanel";
    final static String WEB_HARVEST_PANEL = "vradi.adminXmlStream.webHarvestPanel";
    
    
    void $afterCompleteSetup() {
        SwingUtil.setI18nTableHeaderRenderer(fieldsTable,
            n_("vradi.adminXmlStream.table.field.name"),
            n_("vradi.adminXmlStream.table.field.name.tip"),
            n_("vradi.adminXmlStream.table.field.values"),
            n_("vradi.adminXmlStream.table.field.values.tip"),
            n_("vradi.adminXmlStream.table.field.defaultValue"),
            n_("vradi.adminXmlStream.table.field.defaultValue.tip"));
    
        TableCellRenderer tbc = new DefaultTableCellRenderer() {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value,
                      boolean isSelected, boolean hasFocus, int row, int column) {
    
                String sTranslatedValue = null;
                if (column == 0 && value != null) {
                    String sValue = (String) value;
                    int dot = sValue.lastIndexOf(".");
                    String extName = sValue.substring(0, dot);
                    if (Infogene.EXT_INFOGENE.equals(extName) || Form.EXT_FORM.equals(extName)) {
                        sTranslatedValue = _(sValue);
                    } else {
                        sTranslatedValue = sValue.substring(dot + 1);
                    }
                }
                return super.getTableCellRendererComponent(table, sTranslatedValue, isSelected, hasFocus, row, column);
            }
        };
    
        JListCellRenderer render = new JListCellRenderer(fieldsTable.getDefaultRenderer(String.class));
        setContextValue(render);
    
        SwingUtil.setTableColumnRenderer(fieldsTable, 0, tbc);
        SwingUtil.setTableColumnRenderer(fieldsTable, 1, render);
    
        JListCellEditor editor = new JListCellEditor();
        setContextValue(editor);
        SwingUtil.setTableColumnEditor(fieldsTable, 1, editor);
    
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
            HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        fieldsTable.addHighlighter(highlighter);
        errorTable.registerValidator(validator);
    }
    
    @Override
    protected void postLoadBean() {
        if (bean == null) {
            return;
        }
        
        getHandler().openAdminXmlStreamUI(this);
        xmlStreamPreview.setToolTipText(getFirstElementPreview());
    }
    
    protected void updateFormType() {
        WikittyExtension extension = (WikittyExtension) formTypeCombo.getSelectedItem();
        if (extension != null && bean != null) {
            bean.setFormTypeName(extension.getName());
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    validateFormTypeChoice();
                }
            });
            setModified(true);
        }
    }
    
    protected void validateFormTypeChoice() {
        stopEditing();
        boolean modified = isModified();
        getHandler().updateXmlStreamFieldModel(this);
        setModified(modified);
        validate();
    }
    
    @Override
    public void save() {
        stopEditing();
        
        // add modification info
        String login = getContextValue(VradiUser.class).getLogin();
        ModificationTag xmlStreamTag = VradiService.getWikittyProxy().cast(bean, ModificationTag.class);
        xmlStreamTag.setLastModified(new Date());
        xmlStreamTag.setLastModifier(login);
    
        setModified(false);
    
        XmlStream bean = getBean();
    
        setBean(null);
        
        bean = getHandler().saveStream(this, getHelper(), bean, fieldsModel.getBindings());
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        xmlStreamName.setText("");
        xmlStreamUrl.setText("");
        webHarvestStreamUrl.setText("");
    }
    
    protected void initScriptComboBox() {
        getHandler().initScriptComboBox(webHarvestScript, (WebHarvestStream)getBean());
    }
    
    protected void stopEditing() {
        //FIXME-TC20091116 il faut pouvoir annuler l'édition si on sort du tableau
        if (fieldsTable.getCellEditor() != null) {
            fieldsTable.getCellEditor().stopCellEditing();
        }
    }
    
    protected void createForms() {
        getHandler().createForms(this);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminXmlStream.title", SwingUtil.getStringValue(name));
    }
    
    protected void browseURI(String url) {
        try {
            UIHelper.browseURI(url);
        } catch (IOException eee){
            log.error("Cannot display XMLStream : " + url);
            JOptionPane.showMessageDialog(null,
                    _("vradi.message.cannot.display.stream"));
    
        }
    }
    
    protected String getCardToDisplay() {
        if (getBean() instanceof WebHarvestStream) {
            return WEB_HARVEST_PANEL;
        }
        return XML_STREAM_PANEL;
    }
    
    protected String getFirstElementPreview() {
        return getHandler().getFirstElementPreview(this, getBean());
    }
    
    protected void updateUrl() {
        getBean().setUrl(xmlStreamUrl.getText().matches("\\w+://.*") ? xmlStreamUrl.getText() : "http://" + xmlStreamUrl.getText());
        xmlStreamPreview.setToolTipText(getFirstElementPreview());
    }
    
    protected void updateWebHarvestUrl() {
        getBean().setUrl(webHarvestStreamUrl.getText().matches("\\w+://.*") ? webHarvestStreamUrl.getText() : "http://" + webHarvestStreamUrl.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminXmlStreamUI() {
        super();
        $initialize();
    }

    public AdminXmlStreamUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.XmlStream > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createForms(java.awt.event.ActionEvent event) {
        createForms();
    }

    public void doActionPerformed__on__createWebHarvestStream(java.awt.event.ActionEvent event) {
        getHandler().createWebHarvestStream(this);
    }

    public void doActionPerformed__on__createXmlStream(java.awt.event.ActionEvent event) {
        getHandler().createXmlStream(this);
    }

    public void doActionPerformed__on__formTypeCombo(java.awt.event.ActionEvent event) {
        updateFormType();
    }

    public void doActionPerformed__on__openWebHarvestEditor(java.awt.event.ActionEvent event) {
        getHandler().openWebHarvestEditor(this);
    }

    public void doActionPerformed__on__openWebHarvestScript(java.awt.event.ActionEvent event) {
        getHandler().addWebHarvestScript(this, (WebHarvestStream)getBean());initScriptComboBox();
    }

    public void doActionPerformed__on__validateUrl(java.awt.event.ActionEvent event) {
        validateFormTypeChoice();
    }

    public void doActionPerformed__on__xmlStreamSite(java.awt.event.ActionEvent event) {
        browseURI(getBean().getUrl());
    }

    public void doKeyReleased__on__webHarvestStreamUrl(java.awt.event.KeyEvent event) {
        updateWebHarvestUrl();
    }

    public void doKeyReleased__on__xmlStreamName(java.awt.event.KeyEvent event) {
        getBean().setName(xmlStreamName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__xmlStreamUrl(java.awt.event.KeyEvent event) {
        updateUrl();
    }

    public void doTableChanged__on__fieldsModel(javax.swing.event.TableModelEvent event) {
        setModified(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminXmlStreamForm() {
        return adminXmlStreamForm;
    }

    public com.jurismarches.vradi.entities.XmlStream getBean() {
        return bean;
    }

    public javax.swing.JPanel getCards() {
        return cards;
    }

    public javax.swing.JButton getCreateForms() {
        return createForms;
    }

    public javax.swing.JButton getCreateWebHarvestStream() {
        return createWebHarvestStream;
    }

    public javax.swing.JButton getCreateXmlStream() {
        return createXmlStream;
    }

    public com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel getFieldsModel() {
        return fieldsModel;
    }

    public org.jdesktop.swingx.JXTable getFieldsTable() {
        return fieldsTable;
    }

    public javax.swing.JComboBox getFormTypeCombo() {
        return formTypeCombo;
    }

    public javax.swing.ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public javax.swing.JLabel getLblName() {
        return lblName;
    }

    public javax.swing.JButton getOpenWebHarvestEditor() {
        return openWebHarvestEditor;
    }

    public javax.swing.JButton getOpenWebHarvestScript() {
        return openWebHarvestScript;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    public javax.swing.JButton getValidateUrl() {
        return validateUrl;
    }

    public javax.swing.JComboBox getWebHarvestScript() {
        return webHarvestScript;
    }

    public javax.swing.JTextField getWebHarvestStreamUrl() {
        return webHarvestStreamUrl;
    }

    public com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI getXmlStreamConfig() {
        return xmlStreamConfig;
    }

    public javax.swing.JTextField getXmlStreamName() {
        return xmlStreamName;
    }

    public javax.swing.JLabel getXmlStreamPreview() {
        return xmlStreamPreview;
    }

    public javax.swing.JButton getXmlStreamSite() {
        return xmlStreamSite;
    }

    public javax.swing.JTextField getXmlStreamUrl() {
        return xmlStreamUrl;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.XmlStream newValue) {
        com.jurismarches.vradi.entities.XmlStream oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setFormTypeSelectionModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = newValue;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("formTypeName", formTypeCombo);
        validator.setFieldRepresentation("name", xmlStreamName);
        validator.setFieldRepresentation("url", xmlStreamUrl);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminXmlStreamForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminXmlStreamForm.add(lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(xmlStreamName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(cards, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(SwingUtil.boxComponentWithJxLayer(formTypeCombo), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(validateUrl, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminXmlStreamForm.add(xmlStreamConfig, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminXmlStreamForm, BorderLayout.NORTH);
        body.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToCards() {
        if (!allComponentsCreated) {
            return;
        }
        cards.add($Table0, XML_STREAM_PANEL);
        cards.add($Table1, WEB_HARVEST_PANEL);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminXmlStreamForm() {
        $objectMap.put("adminXmlStreamForm", adminXmlStreamForm = new jaxx.runtime.swing.Table());
        
        adminXmlStreamForm.setName("adminXmlStreamForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCards() {
        $objectMap.put("cards", cards = new javax.swing.JPanel());
        
        cards.setName("cards");
        cards.setLayout(new CardLayout());
    }

    protected void createCreateForms() {
        $objectMap.put("createForms", createForms = new javax.swing.JButton());
        
        createForms.setName("createForms");
        createForms.setText(_("vradi.adminXmlStream.createForms"));
        createForms.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForms"));
    }

    protected void createCreateWebHarvestStream() {
        $objectMap.put("createWebHarvestStream", createWebHarvestStream = new javax.swing.JButton());
        
        createWebHarvestStream.setName("createWebHarvestStream");
        createWebHarvestStream.setText(_("vradi.adminXmlStream.createWebHarvestStream"));
        createWebHarvestStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createWebHarvestStream"));
    }

    protected void createCreateXmlStream() {
        $objectMap.put("createXmlStream", createXmlStream = new javax.swing.JButton());
        
        createXmlStream.setName("createXmlStream");
        createXmlStream.setText(_("vradi.adminXmlStream.createXmlStream"));
        createXmlStream.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createXmlStream"));
    }

    protected void createFieldsModel() {
        $objectMap.put("fieldsModel", fieldsModel = new com.jurismarches.vradi.ui.admin.models.XmlStreamFieldTableModel());
        
        fieldsModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__fieldsModel"));
    }

    protected void createFieldsTable() {
        $objectMap.put("fieldsTable", fieldsTable = new org.jdesktop.swingx.JXTable());
        
        fieldsTable.setName("fieldsTable");
        if (fieldsTable.getFont() != null) {
            fieldsTable.setFont(fieldsTable.getFont().deriveFont((float) 11));
        }
        fieldsTable.setRowSelectionAllowed(false);
    }

    protected void createFormTypeCombo() {
        $objectMap.put("formTypeCombo", formTypeCombo = new javax.swing.JComboBox());
        
        formTypeCombo.setName("formTypeCombo");
        formTypeCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeCombo"));
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = UIHelper.getFormTypesModel());
    }

    protected void createLblName() {
        $objectMap.put("lblName", lblName = new javax.swing.JLabel());
        
        lblName.setName("lblName");
        lblName.setText(_("vradi.adminXmlStream.name"));
    }

    protected void createOpenWebHarvestEditor() {
        $objectMap.put("openWebHarvestEditor", openWebHarvestEditor = new javax.swing.JButton());
        
        openWebHarvestEditor.setName("openWebHarvestEditor");
        openWebHarvestEditor.setToolTipText(_("vradi.adminXmlStream.createNewWebHarvest.toolTip"));
        openWebHarvestEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openWebHarvestEditor"));
    }

    protected void createOpenWebHarvestScript() {
        $objectMap.put("openWebHarvestScript", openWebHarvestScript = new javax.swing.JButton());
        
        openWebHarvestScript.setName("openWebHarvestScript");
        openWebHarvestScript.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openWebHarvestScript"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidateUrl() {
        $objectMap.put("validateUrl", validateUrl = new javax.swing.JButton());
        
        validateUrl.setName("validateUrl");
        validateUrl.setText(_("vradi.adminXmlStream.validateUrl"));
        validateUrl.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateUrl"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.XmlStream >(com.jurismarches.vradi.entities.XmlStream.class, null));
    }

    protected void createWebHarvestScript() {
        $objectMap.put("webHarvestScript", webHarvestScript = new javax.swing.JComboBox());
        
        webHarvestScript.setName("webHarvestScript");
    }

    protected void createWebHarvestStreamUrl() {
        $objectMap.put("webHarvestStreamUrl", webHarvestStreamUrl = new javax.swing.JTextField());
        
        webHarvestStreamUrl.setName("webHarvestStreamUrl");
        webHarvestStreamUrl.setColumns(15);
        webHarvestStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__webHarvestStreamUrl"));
    }

    protected void createXmlStreamConfig() {
        $objectMap.put("xmlStreamConfig", xmlStreamConfig = new com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI());
        
        xmlStreamConfig.setName("xmlStreamConfig");
    }

    protected void createXmlStreamName() {
        $objectMap.put("xmlStreamName", xmlStreamName = new javax.swing.JTextField());
        
        xmlStreamName.setName("xmlStreamName");
        xmlStreamName.setColumns(15);
        xmlStreamName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamName"));
    }

    protected void createXmlStreamPreview() {
        $objectMap.put("xmlStreamPreview", xmlStreamPreview = new javax.swing.JLabel());
        
        xmlStreamPreview.setName("xmlStreamPreview");
    }

    protected void createXmlStreamSite() {
        $objectMap.put("xmlStreamSite", xmlStreamSite = new javax.swing.JButton());
        
        xmlStreamSite.setName("xmlStreamSite");
        xmlStreamSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__xmlStreamSite"));
    }

    protected void createXmlStreamUrl() {
        $objectMap.put("xmlStreamUrl", xmlStreamUrl = new javax.swing.JTextField());
        
        xmlStreamUrl.setName("xmlStreamUrl");
        xmlStreamUrl.setColumns(15);
        xmlStreamUrl.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__xmlStreamUrl"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createXmlStream);
        $JPanel0.add(createWebHarvestStream);
        $JPanel0.add(createForms);
        $JPanel0.add($JButton0);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminXmlStreamForm();
        addChildrenToCards();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(xmlStreamUrl), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(xmlStreamPreview, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(xmlStreamSite, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webHarvestStreamUrl, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(webHarvestScript, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(openWebHarvestScript, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(openWebHarvestEditor, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldsTable);
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 21 property setters
        createXmlStream.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.add"));
        createWebHarvestStream.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.delete"));
        $HidorButton0.setHideTip(_("vradi.adminXmlStream.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminXmlStream.showForm"));
        $HidorButton0.setTarget(adminXmlStreamForm);
        $HidorButton0.setTargetVisible(true);
        adminXmlStreamForm.setMinimumSize(SwingUtil.newMinDimension());
        xmlStreamPreview.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("feed.magnify"));
        xmlStreamPreview.setToolTipText(_(getFirstElementPreview()));
        xmlStreamSite.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        openWebHarvestScript.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("open"));
        openWebHarvestEditor.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("edit"));
        formTypeCombo.setModel(formTypeSelectionModel);
        formTypeCombo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        fieldsTable.setModel(fieldsModel);
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminXmlStreamUI", this);
        createBean();
        createFieldsModel();
        createFormTypeSelectionModel();
        createValidator();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateXmlStream();
        createCreateWebHarvestStream();
        createCreateForms();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminXmlStream.deleteXmlStream"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        createAdminXmlStreamForm();
        createLblName();
        createXmlStreamName();
        createCards();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.url"));
        createXmlStreamUrl();
        createXmlStreamPreview();
        createXmlStreamSite();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminXmlStream.startUrl"));
        createWebHarvestStreamUrl();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminXmlStream.webHarvestScript"));
        createWebHarvestScript();
        createOpenWebHarvestScript();
        createOpenWebHarvestEditor();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminXmlStream.formType"));
        createFormTypeCombo();
        createValidateUrl();
        createXmlStreamConfig();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldsTable();
        // inline creation of adminXmlStreamUI
        setName("adminXmlStreamUI");
        ((jaxx.runtime.swing.Table) adminXmlStreamUI.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_XML_STREAM_UI_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_XML_STREAM_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createXmlStream.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_FORMS_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                createForms.setEnabled(isEnabled() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamName, getBean().getName());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel0.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    javax.swing.JLabel $target = ((javax.swing.JLabel) $bindingSources.remove("lblName"));
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(java.awt.event.ComponentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_URL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(xmlStreamUrl, getBean().getUrl());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel1.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    javax.swing.JLabel $target = ((javax.swing.JLabel) $bindingSources.remove("lblName"));
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(java.awt.event.ComponentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_WEB_HARVEST_STREAM_URL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(webHarvestStreamUrl, getBean().getUrl());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (lblName != null) {
                    $bindingSources.put("lblName", lblName);
                    lblName.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u2"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (lblName != null) {
                    $JLabel2.setSize(lblName.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (lblName != null) {
                    javax.swing.JLabel $target = ((javax.swing.JLabel) $bindingSources.remove("lblName"));
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u2"));
                    }
                }
            }
        
            public void $pr$u2(java.awt.event.ComponentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORM_TYPE_COMBO_SELECTED_ITEM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    formTypeCombo.setSelectedItem(getHandler().getExtension(getBean().getFormTypeName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATE_URL_ENABLED, true ,"enabled" ,"valide") {
        
            @Override
            public void processDataBinding() {
                validateUrl.setEnabled(isEnabled() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_XML_STREAM_CONFIG_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                xmlStreamConfig.setBean(getBean());
            }
        });
    }

}