/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiAction;
import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.ChangeLogHandler;
import com.jurismarches.vradi.ui.ChangeLogUI;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.login.LoginHandler;
import com.jurismarches.vradi.ui.login.LoginUI;
import com.jurismarches.vradi.ui.renderers.NumberListCellRenderer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.util.StringUtil;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.wikitty.WikittyExtension;

public class VradiMain {
    private static Log log = LogFactory.getLog(VradiMain.class);

    public static void main(String[] args) {
        final long startingTime = System.nanoTime();
        log.info((Object)("Vradi start at " + new Date() + " args: " + Arrays.toString(args)));
        try {
            final VradiContext context = VradiMain.init(args);
            log.info((Object)I18n._("vradi.init.context.done", StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
            SwingUtil.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)SwingUtil.newContextEntryDef(VradiConfig.class));
            SwingUtil.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)SwingUtil.newContextEntryDef(VradiAction.class));
            final VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
            config.doAction(VradiConfig.Step.AfterInit.ordinal());
            if (config.isDisplayMainUI()) {
                final LoginHandler handler = UIHelper.getHandler((JAXXContext)context, LoginHandler.class);
                final LoginUI loginUI = new LoginUI((JAXXContext)context);
                loginUI.addPropertyChangeListener("bean", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() != null) {
                            context.setContextValue(evt.getNewValue());
                            loginUI.removePropertyChangeListener(this);
                            loginUI.dispose();
                            try {
                                ChangeLogHandler changeLogHandler = UIHelper.getHandler((JAXXContext)context, ChangeLogHandler.class);
                                String changeLog = changeLogHandler.getChangeLog();
                                if (!changeLog.isEmpty()) {
                                    ChangeLogUI clUI = new ChangeLogUI((JAXXContext)context);
                                    clUI.getContent().setText(changeLog);
                                    clUI.setLocationRelativeTo(null);
                                    clUI.setVisible(true);
                                }
                            }
                            catch (Exception eee) {
                                log.error((Object)"Can't open change log ui : ", (Throwable)eee);
                                ErrorDialogUI.showError((Exception)eee);
                            }
                            VradiMainUIHandler uiHandler = UIHelper.getHandler((JAXXContext)context, VradiMainUIHandler.class);
                            VradiMainUI mainUI = uiHandler.initUI((JAXXContext)context, config.isFullScreen());
                            mainUI.setCursor(null);
                            mainUI.setLocationRelativeTo(null);
                            mainUI.setVisible(true);
                            log.info((Object)I18n._("vradi.init.ui.done", StringUtil.convertTime((long)startingTime, (long)System.nanoTime())));
                        }
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String login = config.getLogin();
                        String password = config.getPassword();
                        VradiUser vradiUser = null;
                        if (StringUtils.isNotBlank((String)login) && StringUtils.isNotBlank((String)password)) {
                            try {
                                vradiUser = handler.getVradiStorageService().loginUser(login, password);
                            }
                            catch (VradiException e) {
                                log.error((Object)e.getMessage());
                            }
                        }
                        if (vradiUser != null) {
                            loginUI.setBean(vradiUser);
                        } else {
                            loginUI.setLocationRelativeTo(null);
                            loginUI.setVisible(true);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
            System.exit(1);
        }
    }

    public static VradiContext init(String ... args) throws Exception {
        System.setSecurityManager(null);
        long t0 = System.nanoTime();
        I18n.setInitializer(new DefaultI18nInitializer("vradi-swing-i18n"));
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        VradiContext context = VradiContext.init();
        DecoratorProvider decoratorProvider = new DecoratorProvider(){

            protected void loadDecorators() {
                this.registerMultiJXPathDecorator(Client.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(User.class, "userOnly", "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Group.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Status.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(WikittyExtension.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(XmlStream.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Thesaurus.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(File.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Form.class, "${objet}$s", "", "");
                this.registerDecorator((Decorator)new Decorator<User>(User.class){

                    public String toString(Object bean) {
                        User user = (User)bean;
                        Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                        String clientString = "";
                        if (client != null) {
                            clientString = client.getName() + " - ";
                        }
                        return clientString + user.getName();
                    }
                });
            }
        };
        context.setContextValue(decoratorProvider);
        context.setContextValue(new DecoratorProviderListCellRenderer(decoratorProvider));
        context.setContextValue(new NumberListCellRenderer());
        VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
        config.parse(args);
        long t00 = System.nanoTime();
        I18n.init(config.getLocale());
        log.info((Object)("language : " + config.getLocale()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
        log.info((Object)I18n._("vradi.message.config.loaded", config.getVersion()));
        try {
            SwingUtil.initNimbusLoookAndFeel();
            ToolTipManager.sharedInstance().setDismissDelay(3600000);
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            defaults.put("SplitPane.oneTouchButtonSize", (Object)10);
            defaults.put("Tree.drawHorizontalLines", Boolean.TRUE);
            defaults.put("Tree.drawVerticalLines", Boolean.TRUE);
            defaults.put("Tree.showRootHandles", Boolean.TRUE);
            defaults.put("Tree.leftChildIndent", (Object)12);
            defaults.put("Tree.rightChildIndent", (Object)12);
            defaults.put("Tree.scrollsOnExpand", Boolean.TRUE);
        }
        catch (Exception e) {
            log.warn((Object)I18n._("vradi.warning.nimbus.landf"));
        }
        catch (Throwable e) {
            log.warn((Object)I18n._("vradi.warning.no.ui"));
            config.setCanUseUI(false);
        }
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
            DateConverter dateConverter = new DateConverter();
            dateConverter.setUseLocaleFormat(true);
            ConvertUtils.register((Converter)dateConverter, Date.class);
        }
        if (config.isCanUseUI()) {
            SwingUtil.loadUIConfig((String)("/" + config.getConfigFileName()), null);
        }
        VradiService.initServiceProxies(config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init done in " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
        }
        return context;
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("shutdown vradi");
        }

        @Override
        public void run() {
            try {
                super.run();
                VradiContext.get().close();
                log.info((Object)I18n._("vradi.init.closed", new Date()));
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

