/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget.editor;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.widget.editor.DefaultEditor;
import org.nuiton.widget.editor.EditorHelper;
import sdoc.Gutter;
import sdoc.SyntaxSupport;

public class SDocEditor
extends DefaultEditor {
    private static final long serialVersionUID = -7907912891843847963L;
    private static Log log = LogFactory.getLog(SDocEditor.class);
    protected SyntaxSupport syntaxSupport = SyntaxSupport.getInstance();

    public SDocEditor() {
        this.editor.setBackground(Color.WHITE);
        this.scrollPane.setRowHeaderView((Component)new Gutter((JTextComponent)this.editor, this.scrollPane));
    }

    @Override
    public boolean accept(File file) {
        String ext = FileUtil.extension((File)file, (String[])new String[0]);
        boolean result = "java".equalsIgnoreCase(ext);
        result = result || "xml".equalsIgnoreCase(ext);
        result = result || "sql".equalsIgnoreCase(ext);
        return result;
    }

    @Override
    public boolean open(File file) {
        block16: {
            try {
                Document doc;
                block15: {
                    doc = this.editor.getDocument();
                    EditorHelper.removeUndoRedoSupport(this.editor);
                    doc.removeDocumentListener(this);
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    String text = "";
                    int last = 0;
                    while ((last = ((Reader)in).read()) != -1) {
                        int c = last;
                        if (13 == c) {
                            ((Reader)in).mark(1);
                            last = ((Reader)in).read();
                            if (last != -1) {
                                if ('\n' != (char)last) {
                                    ((Reader)in).reset();
                                }
                                c = 10;
                            }
                        }
                        text = text + (char)c;
                    }
                    String ext = FileUtil.extension((File)file, (String[])new String[0]);
                    if ("java".equalsIgnoreCase(ext)) {
                        this.syntaxSupport.addSupport(1001, (JTextComponent)this.editor);
                    } else if ("xml".equalsIgnoreCase(ext)) {
                        this.syntaxSupport.addSupport(1002, (JTextComponent)this.editor);
                    } else if ("sql".equalsIgnoreCase(ext)) {
                        this.syntaxSupport.addSupport(1003, (JTextComponent)this.editor);
                    }
                    doc = this.editor.getDocument();
                    try {
                        doc.insertString(0, text, null);
                    }
                    catch (BadLocationException eee) {
                        if (!log.isWarnEnabled()) break block15;
                        log.warn((Object)"Can't insert text", (Throwable)eee);
                    }
                }
                doc = this.editor.getDocument();
                doc.addDocumentListener(this);
                EditorHelper.addUndoRedoSupport(this.editor);
                this.isModified = false;
                return true;
            }
            catch (FileNotFoundException eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Can't find file: " + file), (Throwable)eee);
                }
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block16;
                log.warn((Object)("Can't open file: " + file), (Throwable)eee);
            }
        }
        return false;
    }
}

