/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.beans.BeanUtil;

public class BeanMonitor {
    private static final Log log = LogFactory.getLog(BeanMonitor.class);
    protected final List<String> propertyNames;
    protected final Set<String> modifiedProperties;
    protected final Map<String, Object> originalValues;
    protected final PropertyChangeListener listener;
    protected Object bean;

    public BeanMonitor(String ... propertyNames) {
        this.propertyNames = Arrays.asList(propertyNames);
        this.modifiedProperties = new LinkedHashSet<String>();
        this.originalValues = new TreeMap<String, Object>();
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (!BeanMonitor.this.propertyNames.contains(propertyName)) {
                    return;
                }
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                if (BeanMonitor.this.modifiedProperties.contains(propertyName)) {
                    Object originalValue = BeanMonitor.this.originalValues.get(propertyName);
                    if (originalValue == null && newValue == null || originalValue != null && originalValue.equals(newValue)) {
                        BeanMonitor.this.modifiedProperties.remove(propertyName);
                        BeanMonitor.this.originalValues.remove(propertyName);
                        return;
                    }
                    return;
                }
                BeanMonitor.this.modifiedProperties.add(propertyName);
                BeanMonitor.this.originalValues.put(propertyName, oldValue);
            }
        };
    }

    public Object getBean() {
        return this.bean;
    }

    public boolean wasModified() {
        return !this.modifiedProperties.isEmpty();
    }

    public String[] getModifiedProperties() {
        return this.modifiedProperties.toArray(new String[this.modifiedProperties.size()]);
    }

    public Map<String, Object> getOriginalValues() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(this.originalValues);
        return map;
    }

    public void setBean(Object bean) {
        Object oldBean = this.bean;
        this.bean = bean;
        this.clearModified();
        if (oldBean != null) {
            try {
                BeanUtil.removePropertyChangeListener(this.listener, oldBean);
            }
            catch (Exception eee) {
                log.error((Object)I18n._((String)"nuitonutil.error.could.not.removePCL", (Object[])new Object[]{this.listener, oldBean, eee.getMessage()}));
            }
        }
        if (bean != null) {
            try {
                BeanUtil.addPropertyChangeListener(this.listener, bean);
            }
            catch (Exception eee) {
                log.error((Object)I18n._((String)"nuitonutil.error.could.not.addPCL", (Object[])new Object[]{this.listener, bean, eee.getMessage()}));
            }
        }
    }

    public void clearModified() {
        this.modifiedProperties.clear();
        this.originalValues.clear();
    }
}

