/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;

public class WikittyExtensionMigrationRename
implements WikittyExtensionMigration {
    private static Log log = LogFactory.getLog(WikittyExtensionMigrationRename.class);
    public static final String TAG_RENAME = "renameFrom";

    protected void addExtension(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension newExt) {
        String requires = newExt.getRequires();
        if (StringUtils.isNotEmpty((String)requires)) {
            for (String require : requires.split(",")) {
                WikittyExtension newRequireExt = service.restoreExtensionLastVersion(null, transaction, require);
                this.addExtension(service, transaction, wikitty, newRequireExt);
            }
        }
        wikitty.addExtension(newExt);
    }

    @Override
    public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {
        String wikittyId = wikitty.getId();
        String wikittyVersion = wikitty.getVersion();
        WikittyImpl result = new WikittyImpl(wikittyId);
        result.setVersion(wikittyVersion);
        for (WikittyExtension extension : wikitty.getExtensions()) {
            if (extension.equals(oldExt)) {
                this.addExtension(service, transaction, result, newExt);
                continue;
            }
            this.addExtension(service, transaction, result, extension);
        }
        Set<String> fqFieldNames = wikitty.fieldNames();
        String extName = newExt.getName();
        for (String fieldName : fqFieldNames) {
            if (fieldName.startsWith(extName + ".")) continue;
            Object value = wikitty.getFqField(fieldName);
            log.debug((Object)("Value " + fieldName + "=" + value));
            result.setFqField(fieldName, value);
        }
        Collection<String> oldFieldNames = oldExt.getFieldNames();
        Collection<String> newFieldNames = newExt.getFieldNames();
        for (String fieldName : newFieldNames) {
            Object value;
            FieldType fieldType = newExt.getFieldType(fieldName);
            String renameFrom = fieldType.getTagValue(TAG_RENAME);
            log.debug((Object)("Scan rename migration on " + extName + "." + fieldName + ":" + TAG_RENAME + "=" + renameFrom));
            if (renameFrom != null && !renameFrom.isEmpty()) {
                value = wikitty.getFieldAsObject(extName, renameFrom);
                log.debug((Object)("Rename " + extName + "." + fieldName + "=" + value));
                result.setField(extName, fieldName, value);
                continue;
            }
            if (!oldFieldNames.contains(fieldName)) continue;
            value = wikitty.getFieldAsObject(extName, fieldName);
            log.debug((Object)("Copy " + extName + "." + fieldName + "=" + value));
            result.setField(extName, fieldName, value);
        }
        return result;
    }
}

