/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyUtil;

public class WikittyCache
implements WikittyServiceListener {
    private static Log log = LogFactory.getLog(WikittyCache.class);
    protected Map<String, Wikitty> wikittyCache;

    public WikittyCache() {
        this(true);
    }

    public WikittyCache(boolean soft) {
        this.wikittyCache = soft ? new ReferenceMap(0, 1) : new HashMap<String, Wikitty>();
    }

    public boolean existsWikitty(String id) {
        Wikitty o = this.wikittyCache.get(id);
        boolean result = o != null;
        return result;
    }

    public Wikitty getWikitty(String id) {
        Wikitty result = this.wikittyCache.get(id);
        return result;
    }

    public void putWikitty(Wikitty e) {
        if (e == null) {
            return;
        }
        Wikitty old = this.getWikitty(e.getId());
        if (old == null || WikittyUtil.versionGreaterThan(e.getVersion(), old.getVersion())) {
            this.wikittyCache.put(e.getId(), e);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Replace cached wikitty : new version " + e.getVersion() + " > old version " + (old == null ? null : old.getVersion())));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Ignoring putWikittyEvent : new version " + e.getVersion() + " < old version " + old.getVersion()));
        }
    }

    public void putAllWikitty(Collection<Wikitty> all) {
        for (Wikitty w : all) {
            this.putWikitty(w);
        }
    }

    public void removeWikitty(String id) {
        this.wikittyCache.remove(id);
    }

    public void removeAllWikitty(Collection<String> ids) {
        for (String id : ids) {
            this.removeWikitty(id);
        }
    }

    public void clearWikitty() {
        this.wikittyCache.clear();
    }

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
        this.clearWikitty();
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {
        Set<String> ids = event.getIds();
        Map<String, String> idsVersions = event.getIdVersions();
        for (String id : ids) {
            String version;
            Wikitty currentWikitty = this.getWikitty(id);
            if (currentWikitty == null || !WikittyUtil.versionGreaterThan(version = idsVersions.get(id), currentWikitty.getVersion())) continue;
            this.removeWikitty(id);
        }
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
        for (String id : event.getIds()) {
            this.removeWikitty(id);
        }
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
    }
}

