/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.web;

import java.util.LinkedList;
import org.apache.commons.httpclient.HttpClient;
import org.webharvest.runtime.web.HttpResponseWrapper;
import org.webharvest.utils.KeyValuePair;

public class HttpInfo {
    public HttpClient client;
    public long contentLength = 0L;
    public String charset = "";
    public String mimeType = "";
    public KeyValuePair<String>[] headers = null;
    public int statusCode = 0;
    public String statusText = "";
    public long totalLength = 0L;
    public int totalResponses = 0;

    public HttpInfo(HttpClient client) {
        this.client = client;
    }

    public void setResponse(HttpResponseWrapper wrapper) {
        this.contentLength = wrapper.getContentLength();
        this.charset = wrapper.getCharset();
        this.mimeType = wrapper.getMimeType();
        this.headers = wrapper.getHeaders();
        this.statusCode = wrapper.getStatusCode();
        this.statusText = wrapper.getStatusText();
        this.totalLength += this.contentLength;
        ++this.totalResponses;
    }

    public String getHeader(String key) {
        if (this.headers != null) {
            for (KeyValuePair<String> pair : this.headers) {
                if (!pair.getKey().equalsIgnoreCase(key)) continue;
                return pair.getValue();
            }
        }
        return null;
    }

    public String[] getHeaders(String key) {
        LinkedList<String> result = new LinkedList<String>();
        if (this.headers != null) {
            for (KeyValuePair<String> pair : this.headers) {
                if (!pair.getKey().equalsIgnoreCase(key)) continue;
                result.add(pair.getValue());
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

