/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.scripting;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Map;
import org.webharvest.exception.ScriptException;
import org.webharvest.runtime.scripting.ScriptEngine;

public class BeanShellScriptEngine
extends ScriptEngine {
    private Interpreter beanShellInterpreter = new Interpreter();

    public BeanShellScriptEngine(Map context) {
        super(context);
        this.beanShellInterpreter.getNameSpace().importCommands("org.webharvest.runtime.scripting");
        try {
            this.beanShellInterpreter.set("___web_harvest_context___", (Object)this.context);
        }
        catch (EvalError e) {
            throw new ScriptException("Cannot set Web-Harvest context in scripter: " + e.getMessage(), e);
        }
    }

    @Override
    public void setVariable(String name, Object value) {
        try {
            this.beanShellInterpreter.set(name, value);
        }
        catch (EvalError e) {
            throw new ScriptException("Cannot set variable in scripter: " + e.getMessage(), e);
        }
    }

    @Override
    public Object eval(String expression) {
        this.pushAllVariablesFromContextToScriptEngine();
        try {
            return this.beanShellInterpreter.eval(expression);
        }
        catch (EvalError e) {
            throw new ScriptException("Error during script execution: " + e.getMessage(), e);
        }
    }

    @Override
    public void dispose() {
        this.beanShellInterpreter.getNameSpace().clear();
        super.dispose();
    }
}

