/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.JDirectoryChooser;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JSplitPane;

public class UserPreferences {
    private static ComponentListener windowDimension = new ComponentAdapter(){

        public void componentMoved(ComponentEvent e) {
            this.store((Window)e.getComponent());
        }

        public void componentResized(ComponentEvent e) {
            this.store((Window)e.getComponent());
        }

        private void store(Window w) {
            String bounds = (String)ConverterRegistry.instance().convert(class$java$lang$String == null ? (class$java$lang$String = UserPreferences.class$("java.lang.String")) : class$java$lang$String, w.getBounds());
            UserPreferences.node().node("Windows").put(w.getName() + ".bounds", bounds);
        }
    };
    private static PropertyChangeListener splitPaneListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            JSplitPane split = (JSplitPane)evt.getSource();
            UserPreferences.node().node("JSplitPane").put(split.getName() + ".dividerLocation", String.valueOf(split.getDividerLocation()));
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public static JFileChooser getDefaultFileChooser() {
        return UserPreferences.getFileChooser("default");
    }

    public static JDirectoryChooser getDefaultDirectoryChooser() {
        return UserPreferences.getDirectoryChooser("default");
    }

    public static JFileChooser getFileChooser(String id) {
        JFileChooser chooser = new JFileChooser();
        UserPreferences.track(chooser, "FileChooser." + id + ".path");
        return chooser;
    }

    public static JDirectoryChooser getDirectoryChooser(String id) {
        JDirectoryChooser chooser = new JDirectoryChooser();
        UserPreferences.track(chooser, "DirectoryChooser." + id + ".path");
        return chooser;
    }

    private static void track(JFileChooser chooser, final String key) {
        File file;
        String path = UserPreferences.node().get(key, null);
        if (path != null && (file = new File(path)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        PropertyChangeListener trackPath = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof File) {
                    UserPreferences.node().put(key, ((File)evt.getNewValue()).getAbsolutePath());
                }
            }
        };
        chooser.addPropertyChangeListener("directoryChanged", trackPath);
    }

    public static void track(Window window) {
        Preferences prefs = UserPreferences.node().node("Windows");
        String bounds = prefs.get(window.getName() + ".bounds", null);
        if (bounds != null) {
            Rectangle rect = (Rectangle)ConverterRegistry.instance().convert(Rectangle.class, bounds);
            window.setBounds(rect);
        }
        window.addComponentListener(windowDimension);
    }

    public static void track(JSplitPane split) {
        Preferences prefs = UserPreferences.node().node("JSplitPane");
        int dividerLocation = prefs.getInt(split.getName() + ".dividerLocation", -1);
        if (dividerLocation >= 0) {
            split.setDividerLocation(dividerLocation);
        }
        split.addPropertyChangeListener("dividerLocation", splitPaneListener);
    }

    private static Preferences node() {
        return Preferences.userNodeForPackage(UserPreferences.class).node("UserPreferences");
    }
}

