/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import javax.swing.JFormattedTextField;

public class NumberPropertyEditor
extends AbstractPropertyEditor {
    private Class type;

    public NumberPropertyEditor(Class type) {
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type must be a subclass of Number");
        }
        this.editor = new JFormattedTextField();
        this.type = type;
        ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        ((JFormattedTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
    }

    public Object getValue() {
        Number number = (Number)((JFormattedTextField)this.editor).getValue();
        if (Double.class.equals(this.type)) {
            return new Double(number.doubleValue());
        }
        if (Float.class.equals(this.type)) {
            return new Float(number.floatValue());
        }
        if (Integer.class.equals(this.type)) {
            return new Integer(number.intValue());
        }
        if (Long.class.equals(this.type)) {
            return new Long(number.longValue());
        }
        if (Short.class.equals(this.type)) {
            return new Short(number.shortValue());
        }
        return null;
    }

    public void setValue(Object value) {
        if (value == null) {
            ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        } else if (value instanceof Number) {
            ((JFormattedTextField)this.editor).setValue(value);
        } else {
            ((JFormattedTextField)this.editor).setValue(this.getDefaultValue());
        }
    }

    private Object getDefaultValue() {
        try {
            return this.type.getConstructor(String.class).newInstance("0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

