/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.SCOPE;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class SCOPE_Test
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;
    static final int NUM_MSGS = 5;
    static final long SLEEP_TIME = 1000L;

    @BeforeMethod
    void setUp() throws Exception {
        this.c1 = this.createChannel(true, 2);
        this.c1.setName("A");
        this.c2 = this.createChannel(this.c1);
        this.c2.setName("B");
    }

    @AfterMethod
    void tearDown() throws Exception {
        Util.close(this.c2, this.c1);
    }

    public void testRegularMulticastMessages() throws Exception {
        this.sendMessages(null, false);
    }

    public void testScopedMulticastMessages() throws Exception {
        this.sendMessages(null, true);
    }

    public void testRegularUnicastMessages() throws Exception {
        this.sendMessages(this.c2.getAddress(), false);
    }

    public void testScopedUnicastMessages() throws Exception {
        this.sendMessages(this.c2.getAddress(), true);
    }

    public void testOrderWithScopedMulticasts() throws Exception {
        Short[] scopes;
        ProtocolStack stack = this.c2.getProtocolStack();
        Protocol neighbor = stack.findProtocol(UNICAST.class, UNICAST2.class);
        SCOPE scope = new SCOPE();
        stack.insertProtocolInStack(scope, neighbor, 1);
        scope.init();
        this.c1.connect("SCOPE_Test");
        this.c2.connect("SCOPE_Test");
        assert (this.c2.getView().size() == 2) : "c2.view is " + this.c2.getView();
        MyScopedReceiver receiver = new MyScopedReceiver();
        this.c2.setReceiver(receiver);
        Short[] arr$ = scopes = new Short[]{(short)88, (short)89, (short)90};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            short scope_id = arr$[i$];
            for (long i = 1L; i <= 5L; ++i) {
                Message msg = new Message(null, null, Long.valueOf(i));
                msg.setScope(scope_id);
                System.out.println("-- sending message " + (char)scope_id + "#" + i);
                this.c1.send(msg);
            }
        }
        long target_time = System.currentTimeMillis() + 10000L;
        long start = System.currentTimeMillis();
        while (receiver.size() < 5 * scopes.length) {
            Util.sleep(100L);
            System.out.print(".");
            if (target_time > System.currentTimeMillis()) continue;
        }
        long time = System.currentTimeMillis() - start;
        ConcurrentMap<Short, List<Long>> msgs = receiver.getMsgs();
        System.out.println("seqnos:");
        for (Map.Entry entry : msgs.entrySet()) {
            short tmp = (Short)entry.getKey();
            System.out.println((char)tmp + ": " + entry.getValue());
        }
        System.out.println(receiver.size() + " msgs in " + time + " ms");
        assert (receiver.size() == 5 * scopes.length);
        assert (time >= 5000L && time < 10000L);
        System.out.println("checking order within the scopes:");
        Short[] arr$2 = scopes;
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            short scope_id = arr$2[i$];
            List list = (List)msgs.get(scope_id);
            for (int i = 0; i < 5; ++i) {
                assert ((long)(i + 1) == (Long)list.get(i));
            }
        }
        System.out.println("OK, order is correct");
    }

    private void sendMessages(Address dest, boolean use_scopes) throws Exception {
        if (use_scopes) {
            ProtocolStack stack = this.c2.getProtocolStack();
            Protocol neighbor = stack.findProtocol(UNICAST.class, UNICAST2.class);
            SCOPE scope = new SCOPE();
            stack.insertProtocolInStack(scope, neighbor, 1);
            scope.init();
        }
        this.c1.connect("SCOPE_Test");
        this.c2.connect("SCOPE_Test");
        assert (this.c2.getView().size() == 2) : "c2.view is " + this.c2.getView();
        MyReceiver receiver = new MyReceiver();
        this.c2.setReceiver(receiver);
        for (long i = 1L; i <= 5L; ++i) {
            Message msg = new Message(dest, null, Long.valueOf(i));
            if (use_scopes) {
                msg.setScope((short)i);
            }
            System.out.println("-- sending message #" + i);
            this.c1.send(msg);
        }
        long target_time = System.currentTimeMillis() + 10000L;
        long start = System.currentTimeMillis();
        while (receiver.size() < 5) {
            Util.sleep(100L);
            System.out.print(".");
            if (target_time > System.currentTimeMillis()) continue;
        }
        long time = System.currentTimeMillis() - start;
        List<Long> seqnos = receiver.getSeqnos();
        System.out.println("\nsequence numbers: " + seqnos + " in " + time + " ms");
        assert (seqnos.size() == 5);
        if (use_scopes) {
            assert (time > 1000L && time < 5000L);
            for (int i = 0; i < 5; ++i) {
                assert (seqnos.contains((long)i + 1L));
            }
        } else {
            assert (time >= 5000L);
            for (int i = 0; i < 5; ++i) {
                assert ((long)(i + 1) == seqnos.get(i));
            }
        }
    }

    public static class MyScopedReceiver
    extends ReceiverAdapter {
        final ConcurrentMap<Short, List<Long>> msgs = new ConcurrentHashMap<Short, List<Long>>();

        @Override
        public void receive(Message msg) {
            Util.sleep(1000L);
            Short scope = msg.getScope();
            if (scope > 0) {
                List tmp;
                List<Long> list = (ArrayList<Long>)this.msgs.get(scope);
                if (list == null && (tmp = (List)this.msgs.putIfAbsent(scope, list = new ArrayList<Long>(5))) != null) {
                    list = tmp;
                }
                list.add((Long)msg.getObject());
            }
        }

        public ConcurrentMap<Short, List<Long>> getMsgs() {
            return this.msgs;
        }

        public int size() {
            int retval = 0;
            for (List list : this.msgs.values()) {
                retval += list.size();
            }
            return retval;
        }
    }

    public static class MyReceiver
    extends ReceiverAdapter {
        final List<Long> seqnos = Collections.synchronizedList(new LinkedList());

        public List<Long> getSeqnos() {
            return this.seqnos;
        }

        @Override
        public void receive(Message msg) {
            Util.sleep(1000L);
            Long num = (Long)msg.getObject();
            this.seqnos.add(num);
        }

        public int size() {
            return this.seqnos.size();
        }
    }
}

