/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class LatencyTest {
    JChannel ch;

    private void start(boolean sender, boolean local, String props) throws Exception {
        if (local) {
            JChannel ch1 = new JChannel(props);
            ch1.connect("x");
            JChannel ch2 = new JChannel(props);
            ch2.setReceiver(new MyReceiver());
            ch2.connect("x");
            for (int i = 0; i < 10; ++i) {
                Message msg = new Message();
                msg.setFlag((byte)12);
                msg.setObject(Long.valueOf(System.nanoTime()));
                ch1.send(msg);
                Util.sleep(1000L);
            }
            ch2.close();
            ch1.close();
            return;
        }
        if (sender) {
            this.ch = new JChannel(props);
            LatencyTest.disableBundling(this.ch);
            this.ch.connect("x");
            for (int i = 0; i < 10; ++i) {
                Message msg = new Message();
                msg.setFlag((byte)12);
                msg.setObject(Long.valueOf(System.nanoTime()));
                this.ch.send(msg);
                Util.sleep(1000L);
            }
        } else {
            this.ch = new JChannel(props);
            LatencyTest.disableBundling(this.ch);
            this.ch.setReceiver(new MyReceiver());
            this.ch.connect("x");
            System.out.println("receiver ready");
            while (true) {
                Util.sleep(10000L);
            }
        }
        this.ch.close();
    }

    private static void disableBundling(JChannel ch) {
        System.out.println("Disabling message bundling (as this would increase latency)");
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        transport.setEnableBundling(false);
    }

    public static void main(String[] args) throws Exception {
        boolean sender = false;
        boolean local = false;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-sender")) {
                sender = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-local")) {
                local = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-props")) {
                props = args[++i];
                continue;
            }
            LatencyTest.help();
            return;
        }
        new LatencyTest().start(sender, local, props);
    }

    private static void help() {
        System.out.println("JGroupsLatencyTest [-sender] [-local] [-props <properties>]");
    }

    static class MyReceiver
    extends ReceiverAdapter {
        MyReceiver() {
        }

        @Override
        public void receive(Message msg) {
            Long timestamp = (Long)msg.getObject();
            long time = System.nanoTime() - timestamp;
            double time_ms = (double)time / 1000.0 / 1000.0;
            System.out.println("time for message: " + Util.format(time_ms) + " ms");
        }
    }
}

