/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jgroups.ChannelException;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class LargeStateTransferTest
extends ChannelTestBase {
    JChannel provider;
    JChannel requester;
    Promise<Integer> p = new Promise();
    static final int SIZE_1 = 100000;
    static final int SIZE_2 = 1000000;
    static final int SIZE_3 = 5000000;
    static final int SIZE_4 = 10000000;

    @Override
    protected boolean useBlocking() {
        return true;
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.provider = this.createChannel(true, 2);
        this.provider.setName("provider");
        LargeStateTransferTest.modifyStack(this.provider);
        this.requester = this.createChannel(this.provider);
        this.requester.setName("requester");
        LargeStateTransferTest.setOOBPoolSize(this.provider, this.requester);
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        Util.close(this.requester, this.provider);
    }

    public void testStateTransfer1() throws ChannelException {
        this._testStateTransfer(100000, "testStateTransfer1");
    }

    public void testStateTransfer2() throws ChannelException {
        this._testStateTransfer(1000000, "testStateTransfer2");
    }

    public void testStateTransfer3() throws ChannelException {
        this._testStateTransfer(5000000, "testStateTransfer3");
    }

    public void testStateTransfer4() throws ChannelException {
        this._testStateTransfer(10000000, "testStateTransfer4");
    }

    private void _testStateTransfer(int size, String suffix) throws ChannelException {
        String GROUP = "LargeStateTransferTest-" + suffix;
        this.provider.setReceiver(new Provider(size));
        this.provider.connect(GROUP);
        this.p.reset();
        this.requester.setReceiver(new Requester(this.p));
        this.requester.connect(GROUP);
        View requester_view = this.requester.getView();
        assert (requester_view.size() == 2) : "requester view is " + requester_view + ", but should have 2 members";
        View provider_view = this.provider.getView();
        assert (provider_view.size() == 2) : "provider view is " + provider_view + ", but should have 2 members";
        LargeStateTransferTest.log("requesting state of " + Util.printBytes(size));
        long start = System.currentTimeMillis();
        this.requester.getState(this.provider.getAddress(), 20000L);
        Integer result = this.p.getResult(20000L);
        long stop = System.currentTimeMillis();
        LargeStateTransferTest.assertNotNull(result);
        LargeStateTransferTest.log("received " + Util.printBytes(result.intValue()) + " (in " + (stop - start) + "ms)");
        assert (result == size) : "result=" + result + ", expected=" + size;
    }

    private static void setOOBPoolSize(JChannel ... channels) {
        for (JChannel channel : channels) {
            TP transport = channel.getProtocolStack().getTransport();
            transport.setOOBThreadPoolMinThreads(1);
            transport.setOOBThreadPoolMaxThreads(2);
        }
    }

    static void log(String msg) {
        System.out.println(" -- " + msg);
    }

    private static void modifyStack(JChannel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol((Class<?>)GMS.class);
        if (gms != null) {
            gms.setLogCollectMessages(false);
        }
    }

    private static class Requester
    extends ExtendedReceiverAdapter {
        private final Promise<Integer> promise;

        public Requester(Promise<Integer> p) {
            this.promise = p;
        }

        @Override
        public byte[] getState() {
            throw new UnsupportedOperationException("not implemented by requester");
        }

        @Override
        public void setState(byte[] state) {
            this.promise.setResult(new Integer(state.length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void setState(InputStream istream) {
            DataInputStream in = null;
            int size = 0;
            try {
                in = new DataInputStream(istream);
                size = in.readInt();
                byte[] stateReceived = new byte[size];
                in.readFully(stateReceived, 0, stateReceived.length);
            }
            catch (IOException e) {
                Util.close(in);
                catch (Throwable throwable) {
                    Util.close(in);
                    throw throwable;
                }
            }
            Util.close(in);
            this.promise.setResult(size);
        }
    }

    private static class Provider
    extends ExtendedReceiverAdapter {
        private final byte[] state;

        public Provider(int size) {
            this.state = new byte[size];
        }

        @Override
        public byte[] getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void getState(OutputStream ostream) {
            DataOutputStream out = null;
            try {
                out = new DataOutputStream(ostream);
                out.writeInt(this.state.length);
                out.write(this.state, 0, this.state.length);
            }
            catch (IOException iOException) {
                Util.close(out);
                catch (Throwable throwable) {
                    Util.close(out);
                    throw throwable;
                }
            }
            Util.close(out);
        }

        @Override
        public void setState(byte[] state) {
            throw new UnsupportedOperationException("not implemented by provider");
        }
    }
}

