/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Global;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.ExponentialInterval;
import org.jgroups.stack.Interval;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Buffer;
import org.jgroups.util.Digest;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Reliable transmission multipoint FIFO protocol")
@DeprecatedProperty(names={"max_xmit_size", "eager_lock_release", "stats_list_size"})
public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand,
NakReceiverWindow.Listener,
TP.ProbeHandler {
    private static final double WEIGHT = 0.9;
    private static final double INITIAL_SMOOTHED_AVG = 30.0;
    private static final int NUM_REBROADCAST_MSGS = 3;
    @Property(name="retransmit_timeout", converter=PropertyConverters.LongArray.class, description="Timeout before requesting retransmissions. Default is 600, 1200, 2400, 4800")
    private long[] retransmit_timeouts = new long[]{600L, 1200L, 2400L, 4800L};
    @Property(description="If true, retransmissions stats will be captured. Default is false")
    boolean enable_xmit_time_stats = false;
    @Property(description="Garbage collection lag")
    private int gc_lag = 20;
    @Property(description="Max number of messages to be removed from a NakReceiverWindow. This property might get removed anytime, so don't use it !")
    private int max_msg_batch_size = 20000;
    @Property(description="Retransmit messages using multicast rather than unicast")
    private boolean use_mcast_xmit = true;
    @Property(description="Use a multicast to request retransmission of missing messages. Default is false")
    private boolean use_mcast_xmit_req = false;
    @Property(description="Ask a random member for retransmission of a missing message. Default is false")
    private boolean xmit_from_random_member = false;
    @Property(description="The first value (in milliseconds) to use in the exponential backoff. Enabled if greater than 0. Default is 0")
    private long exponential_backoff = 0L;
    @Property(description="Use statistics gathered from actual retransmission times to compute new retransmission times. Default is false")
    private boolean use_stats_for_retransmission = false;
    @Property(description="Whether to use the old retransmitter which retransmits individual messages or the new one which uses ranges of retransmitted messages. Default is true. Note that this property will be removed in 3.0; it is only used to switch back to the old (and proven) retransmitter mechanism if issues occur")
    @Deprecated
    private boolean use_range_based_retransmitter = true;
    @Property(description="Should messages delivered to application be discarded")
    private boolean discard_delivered_msgs = false;
    @Property(description="If value is > 0, the retransmit buffer is bounded. If value <= 0 unbounded buffers are used. Default is 0")
    private int max_xmit_buf_size = 0;
    @Property(description="Size of retransmission history. Default is 50 entries")
    private int xmit_history_max_size = 50;
    @Property(description="Timeout to rebroadcast messages. Default is 2000 msec")
    private long max_rebroadcast_timeout = 2000L;
    @Property(description="Should stability history be printed if we fail in retransmission. Default is false")
    protected boolean print_stability_history_on_failed_xmit = false;
    @Property(description="discards warnings about promiscuous traffic")
    private boolean log_discard_msgs = true;
    @Property(description="If true, trashes warnings about retransmission messages not found in the xmit_table (used for testing)")
    private boolean log_not_found_msgs = true;
    @ManagedAttribute(description="Number of retransmit requests received")
    private long xmit_reqs_received;
    @ManagedAttribute(description="Number of retransmit requests sent")
    private long xmit_reqs_sent;
    @ManagedAttribute(description="Number of retransmit responses received")
    private long xmit_rsps_received;
    @ManagedAttribute(description="Number of retransmit responses sent")
    private long xmit_rsps_sent;
    @ManagedAttribute(description="Number of missing messages received")
    private long missing_msgs_received;
    private ConcurrentMap<Long, XmitTimeStat> xmit_time_stats = null;
    private long xmit_time_stats_start;
    private ConcurrentMap<Address, StatsEntry> sent = new ConcurrentHashMap<Address, StatsEntry>();
    private ConcurrentMap<Address, StatsEntry> received = new ConcurrentHashMap<Address, StatsEntry>();
    private final ConcurrentMap<Address, ConcurrentMap<Long, Long>> xmit_stats = new ConcurrentHashMap<Address, ConcurrentMap<Long, Long>>();
    private final ConcurrentMap<Address, BoundedList<Long>> xmit_times_history = new ConcurrentHashMap<Address, BoundedList<Long>>();
    private final Map<Address, Double> smoothed_avg_xmit_times = new HashMap<Address, Double>();
    private final BoundedList<String> xmit_history = new BoundedList(50);
    private boolean is_server = false;
    private Address local_addr = null;
    private final List<Address> members = new CopyOnWriteArrayList<Address>();
    private View view;
    private long seqno = 0L;
    private final Lock seqno_lock = new ReentrantLock();
    private final ConcurrentMap<Address, NakReceiverWindow> xmit_table = new ConcurrentHashMap<Address, NakReceiverWindow>(11);
    private volatile boolean leaving = false;
    private volatile boolean running = false;
    private TimeScheduler timer = null;
    private final Lock rebroadcast_lock = new ReentrantLock();
    private final Condition rebroadcast_done = this.rebroadcast_lock.newCondition();
    private volatile boolean rebroadcasting = false;
    private final Lock rebroadcast_digest_lock = new ReentrantLock();
    private Digest rebroadcast_digest = null;
    protected final BoundedList<Digest> stability_msgs = new BoundedList(10);
    protected final BoundedList<String> digest_history = new BoundedList(10);
    private final AtomicInteger undelivered_msgs = new AtomicInteger(0);

    @ManagedAttribute
    public int getUndeliveredMessages() {
        return this.undelivered_msgs.get();
    }

    public long getXmitRequestsReceived() {
        return this.xmit_reqs_received;
    }

    public long getXmitRequestsSent() {
        return this.xmit_reqs_sent;
    }

    public long getXmitResponsesReceived() {
        return this.xmit_rsps_received;
    }

    public long getXmitResponsesSent() {
        return this.xmit_rsps_sent;
    }

    public long getMissingMessagesReceived() {
        return this.missing_msgs_received;
    }

    @ManagedAttribute(description="Total number of missing messages")
    public int getPendingRetransmissionRequests() {
        int num = 0;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            num += win.getPendingXmits();
        }
        return num;
    }

    @ManagedAttribute
    public int getXmitTableSize() {
        int num = 0;
        for (NakReceiverWindow win : this.xmit_table.values()) {
            num += win.size();
        }
        return num;
    }

    @ManagedOperation
    public String printRetransmitStats() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(((NakReceiverWindow)entry.getValue()).printRetransmitStats()).append("\n");
        }
        return sb.toString();
    }

    public int getReceivedTableSize() {
        return this.getPendingRetransmissionRequests();
    }

    public NakReceiverWindow getWindow(Address mbr) {
        return (NakReceiverWindow)this.xmit_table.get(mbr);
    }

    @Override
    public void resetStats() {
        this.missing_msgs_received = 0L;
        this.xmit_rsps_sent = 0L;
        this.xmit_rsps_received = 0L;
        this.xmit_reqs_sent = 0L;
        this.xmit_reqs_received = 0L;
        this.sent.clear();
        this.received.clear();
        this.stability_msgs.clear();
        this.digest_history.clear();
        this.xmit_history.clear();
    }

    @Override
    public void init() throws Exception {
        TP transport;
        if (this.enable_xmit_time_stats) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("enable_xmit_time_stats is experimental, and may be removed in any release");
            }
            this.xmit_time_stats = new ConcurrentHashMap<Long, XmitTimeStat>();
            this.xmit_time_stats_start = System.currentTimeMillis();
        }
        if (this.xmit_from_random_member && this.discard_delivered_msgs) {
            this.discard_delivered_msgs = false;
            this.log.warn("xmit_from_random_member set to true: changed discard_delivered_msgs to false");
        }
        if ((transport = this.getTransport()) != null) {
            transport.registerProbeHandler(this);
            if (!transport.supportsMulticasting()) {
                if (this.use_mcast_xmit) {
                    this.log.warn("use_mcast_xmit should not be used because the transport (" + transport.getName() + ") does not support IP multicasting; setting use_mcast_xmit to false");
                    this.use_mcast_xmit = false;
                }
                if (this.use_mcast_xmit_req) {
                    this.log.warn("use_mcast_xmit_req should not be used because the transport (" + transport.getName() + ") does not support IP multicasting; setting use_mcast_xmit_req to false");
                    this.use_mcast_xmit_req = false;
                }
            }
        }
    }

    public int getGcLag() {
        return this.gc_lag;
    }

    public void setGcLag(int gc_lag) {
        this.gc_lag = gc_lag;
    }

    public boolean isUseMcastXmit() {
        return this.use_mcast_xmit;
    }

    public void setUseMcastXmit(boolean use_mcast_xmit) {
        this.use_mcast_xmit = use_mcast_xmit;
    }

    public boolean isXmitFromRandomMember() {
        return this.xmit_from_random_member;
    }

    public void setXmitFromRandomMember(boolean xmit_from_random_member) {
        this.xmit_from_random_member = xmit_from_random_member;
    }

    public boolean isDiscardDeliveredMsgs() {
        return this.discard_delivered_msgs;
    }

    public void setDiscardDeliveredMsgs(boolean discard_delivered_msgs) {
        boolean old = this.discard_delivered_msgs;
        this.discard_delivered_msgs = discard_delivered_msgs;
        if (old != this.discard_delivered_msgs) {
            for (NakReceiverWindow win : this.xmit_table.values()) {
                win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
            }
        }
    }

    public int getMaxXmitBufSize() {
        return this.max_xmit_buf_size;
    }

    public void setMaxXmitBufSize(int max_xmit_buf_size) {
        this.max_xmit_buf_size = max_xmit_buf_size;
    }

    public long getMaxXmitSize() {
        return -1L;
    }

    public void setMaxXmitSize(long max_xmit_size) {
    }

    public void setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
    }

    public void setLogDiscardMsgs(boolean flag) {
        this.setLogDiscardMessages(flag);
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("msgs", this.printMessages());
        return retval;
    }

    @Override
    public String printStats() {
        StatsEntry val;
        Object key;
        StringBuilder sb = new StringBuilder();
        sb.append("sent:\n");
        for (Map.Entry entry : this.sent.entrySet()) {
            key = entry.getKey();
            if (key == null || key == Global.NULL) {
                key = "<mcast dest>";
            }
            val = (StatsEntry)entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        for (Map.Entry entry : this.received.entrySet()) {
            key = entry.getKey();
            if (key == null || key == Global.NULL) {
                key = "<mcast dest>";
            }
            val = (StatsEntry)entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nStability messages received\n");
        sb.append(this.printStabilityMessages()).append("\n");
        return sb.toString();
    }

    @ManagedOperation(description="TODO")
    public String printStabilityMessages() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.printListWithDelimiter(this.stability_msgs, "\n"));
        return sb.toString();
    }

    public String printStabilityHistory() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Digest digest : this.stability_msgs) {
            sb.append(i++).append(": ").append(digest).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Keeps information about the last N times a digest was set or merged")
    public String printDigestHistory() {
        StringBuilder sb = new StringBuilder(this.local_addr + ":\n");
        for (String tmp : this.digest_history) {
            sb.append(tmp).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="TODO")
    public String printLossRates() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            sb.append(entry.getKey()).append(": ").append(win.printLossRate()).append("\n");
        }
        return sb.toString();
    }

    @ManagedAttribute
    public double getAverageLossRate() {
        double retval = 0.0;
        int count = 0;
        if (this.xmit_table.isEmpty()) {
            return 0.0;
        }
        for (NakReceiverWindow win : this.xmit_table.values()) {
            retval += win.getLossRate();
            ++count;
        }
        return retval / (double)count;
    }

    @ManagedAttribute
    public double getAverageSmoothedLossRate() {
        double retval = 0.0;
        int count = 0;
        if (this.xmit_table.isEmpty()) {
            return 0.0;
        }
        for (NakReceiverWindow win : this.xmit_table.values()) {
            retval += win.getSmoothedLossRate();
            ++count;
        }
        return retval / (double)count;
    }

    @Override
    public Vector<Integer> providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>(5);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(53));
        return retval;
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.running = true;
        this.leaving = false;
        if (this.xmit_time_stats != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    String filename = "xmit-stats-" + NAKACK.this.local_addr + ".log";
                    try {
                        NAKACK.this.dumpXmitStats(filename);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void stop() {
        this.running = false;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress()) break;
                this.send(evt, msg);
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 39: {
                return this.getDigest();
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return null;
            }
            case 42: {
                this.overwriteDigest((Digest)evt.getArg());
                return null;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return null;
            }
            case 15: {
                View tmp_view = (View)evt.getArg();
                Vector<Address> mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                break;
            }
            case 6: {
                View tmp_view = (View)evt.getArg();
                Vector<Address> mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.view = tmp_view;
                this.adjustReceivers(this.members);
                this.is_server = true;
                LinkedHashSet<Address> tmp = new LinkedHashSet<Address>(this.members);
                tmp.add(null);
                this.sent.keySet().retainAll(tmp);
                this.received.keySet().retainAll(tmp);
                this.xmit_stats.keySet().retainAll(tmp);
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 4: {
                this.leaving = true;
                this.reset();
                break;
            }
            case 78: {
                this.rebroadcasting = true;
                this.rebroadcast_digest = (Digest)evt.getArg();
                try {
                    this.rebroadcastMessages();
                }
                finally {
                    this.rebroadcasting = false;
                    this.rebroadcast_digest_lock.lock();
                    try {
                        this.rebroadcast_digest = null;
                    }
                    finally {
                        this.rebroadcast_digest_lock.unlock();
                    }
                }
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                NakAckHeader hdr = (NakAckHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                if (!this.is_server) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("message was discarded (not yet server)");
                    }
                    return null;
                }
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return null;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("XMIT_REQ: range of xmit msg is null; discarding request from " + msg.getSrc());
                            }
                            return null;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high, hdr.sender);
                        return null;
                    }
                    case 3: {
                        this.handleXmitRsp(msg);
                        return null;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error("NakAck header type " + hdr.type + " not known !");
                }
                return null;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return null;
            }
            case 9: {
                if (!this.rebroadcasting) break;
                this.cancelRebroadcasting();
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Event evt, Message msg) {
        block15: {
            long msg_id;
            if (msg == null) {
                throw new NullPointerException("msg is null; event is " + evt);
            }
            if (!this.running) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[" + this.local_addr + "] discarded message as we're not in the 'running' state, message: " + msg);
                }
                return;
            }
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(this.local_addr);
            if (win == null) {
                if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                    this.log.warn(this.local_addr + ": discarded message from " + this.local_addr + " with no window, my view is " + this.view);
                }
                return;
            }
            msg.setSrc(this.local_addr);
            this.seqno_lock.lock();
            try {
                try {
                    msg_id = this.seqno + 1L;
                    msg.putHeader(this.id, NakAckHeader.createMessageHeader(msg_id));
                    if (win.add(msg_id, msg) && !msg.isFlagSet((byte)1)) {
                        this.undelivered_msgs.incrementAndGet();
                    }
                    this.seqno = msg_id;
                }
                catch (Throwable t) {
                    throw new RuntimeException("failure adding msg " + msg + " to the retransmit table for " + this.local_addr, t);
                }
            }
            finally {
                this.seqno_lock.unlock();
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("sending " + this.local_addr + "#" + msg_id);
                }
                this.down_prot.down(evt);
            }
            catch (Throwable t) {
                if (!this.log.isWarnEnabled()) break block15;
                this.log.warn("failure passing message down", t);
            }
        }
    }

    private void handleMessage(Message msg, NakAckHeader hdr) {
        AtomicBoolean processing;
        boolean added;
        NakReceiverWindow win;
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("sender of message is null");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(": received ").append(sender).append('#').append(hdr.seqno));
        }
        if ((win = (NakReceiverWindow)this.xmit_table.get(sender)) == null) {
            if (this.leaving) {
                return;
            }
            if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                this.log.warn(this.local_addr + ": dropped message from " + sender + " (not in xmit_table), keys are " + this.xmit_table.keySet() + ", view=" + this.view);
            }
            return;
        }
        boolean loopback = this.local_addr.equals(sender);
        boolean added_to_window = false;
        boolean bl = added = loopback || (added_to_window = win.add(hdr.seqno, msg));
        if (added_to_window && !msg.isFlagSet((byte)1)) {
            this.undelivered_msgs.incrementAndGet();
        }
        if (msg.isFlagSet((byte)1)) {
            List<Message> msgs;
            if (added && (msg = win.get(hdr.seqno)) != null && msg.isFlagSet((byte)1) && msg.setTransientFlagIfAbsent((byte)1)) {
                this.up_prot.up(new Event(1, msg));
            }
            while (!(msgs = win.removeOOBMessages()).isEmpty()) {
                for (Message tmp_msg : msgs) {
                    if (!tmp_msg.setTransientFlagIfAbsent((byte)1)) continue;
                    this.up_prot.up(new Event(1, tmp_msg));
                }
            }
            if (!win.hasMessagesToRemove() || this.undelivered_msgs.get() <= 0) {
                return;
            }
        }
        if (!(processing = win.getProcessing()).compareAndSet(false, true)) {
            return;
        }
        int num_regular_msgs_removed = 0;
        boolean released_processing = false;
        try {
            block8: while (true) {
                List<Message> msgs;
                if ((msgs = win.removeMany(processing, this.max_msg_batch_size)) == null || msgs.isEmpty()) {
                    released_processing = true;
                    return;
                }
                Iterator<Message> i$ = msgs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block8;
                    final Message msg_to_deliver = i$.next();
                    if (msg_to_deliver.isFlagSet((byte)1)) {
                        if (!msg_to_deliver.setTransientFlagIfAbsent((byte)1)) continue;
                        this.timer.execute(new Runnable(){

                            @Override
                            public void run() {
                                NAKACK.this.up_prot.up(new Event(1, msg_to_deliver));
                            }
                        });
                        continue;
                    }
                    ++num_regular_msgs_removed;
                    try {
                        this.up_prot.up(new Event(1, msg_to_deliver));
                    }
                    catch (Throwable t) {
                        this.log.error("couldn't deliver message " + msg_to_deliver, t);
                    }
                }
                break;
            }
        }
        finally {
            this.undelivered_msgs.addAndGet(-num_regular_msgs_removed);
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    private void handleXmitReq(Address xmit_requester, long first_seqno, long last_seqno, Address original_sender) {
        NakReceiverWindow win;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(": received xmit request from ").append(xmit_requester).append(" for ");
            sb.append(original_sender).append(" [").append(first_seqno).append(" - ").append(last_seqno).append("]");
            this.log.trace(sb.toString());
        }
        if (first_seqno > last_seqno) {
            return;
        }
        if (this.stats) {
            this.xmit_reqs_received += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.received, xmit_requester, 1, 0, 0);
        }
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                XmitTimeStat stat2 = this.xmit_time_stats.putIfAbsent(key, stat);
                if (stat2 != null) {
                    stat = stat2;
                }
            }
            stat.xmit_reqs_received.addAndGet((int)(last_seqno - first_seqno + 1L));
            stat.xmit_rsps_sent.addAndGet((int)(last_seqno - first_seqno + 1L));
        }
        if ((win = (NakReceiverWindow)this.xmit_table.get(original_sender)) == null) {
            if (this.log.isErrorEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                sb.append(") ").append(original_sender).append(" not found in retransmission table");
                if (this.log.isTraceEnabled()) {
                    sb.append(":\n").append(this.printMessages());
                }
                if (this.print_stability_history_on_failed_xmit) {
                    sb.append(" (stability history:\n").append(this.printStabilityHistory());
                }
                this.log.error(sb.toString());
            }
            return;
        }
        for (long i = first_seqno; i <= last_seqno; ++i) {
            Message msg = win.get(i);
            if (msg == null) {
                if (!this.log.isWarnEnabled() || !this.log_not_found_msgs || this.local_addr.equals(xmit_requester)) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                sb.append(") message ").append(original_sender).append("::").append(i);
                sb.append(" not found in retransmission table of ").append(original_sender).append(":\n").append(win);
                if (this.print_stability_history_on_failed_xmit) {
                    sb.append(" (stability history:\n").append(this.printStabilityHistory());
                }
                this.log.warn(sb.toString());
                continue;
            }
            this.sendXmitRsp(xmit_requester, msg, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRebroadcasting() {
        this.rebroadcast_lock.lock();
        try {
            this.rebroadcasting = false;
            this.rebroadcast_done.signalAll();
        }
        finally {
            this.rebroadcast_lock.unlock();
        }
    }

    private static void updateStats(ConcurrentMap<Address, StatsEntry> map, Address key, int req, int rsp, int missing) {
        StatsEntry tmp;
        StatsEntry entry = (StatsEntry)map.get(key);
        if (entry == null && (tmp = map.putIfAbsent(key, entry = new StatsEntry())) != null) {
            entry = tmp;
        }
        entry.xmit_reqs += (long)req;
        entry.xmit_rsps += (long)rsp;
        entry.missing_msgs_rcvd += (long)missing;
    }

    private void sendXmitRsp(Address dest, Message msg, long seqno) {
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("message is null, cannot send retransmission");
            }
            return;
        }
        if (this.stats) {
            ++this.xmit_rsps_sent;
            NAKACK.updateStats(this.sent, dest, 0, 1, 0);
        }
        if (this.use_mcast_xmit) {
            dest = null;
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        try {
            Buffer buf = Util.messageToByteBuffer(msg);
            Message xmit_msg = new Message(dest, null, buf.getBuf(), buf.getOffset(), buf.getLength());
            if (msg.isFlagSet((byte)1)) {
                xmit_msg.setFlag((byte)1);
            }
            xmit_msg.putHeader(this.id, NakAckHeader.createXmitResponseHeader());
            this.down_prot.down(new Event(1, xmit_msg));
        }
        catch (IOException ex) {
            this.log.error("failed marshalling xmit list", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleXmitRsp(Message msg) {
        block12: {
            if (msg == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("message is null");
                }
                return;
            }
            try {
                boolean cancel_rebroadcasting;
                Message wrapped_msg = Util.byteBufferToMessage(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                if (this.xmit_time_stats != null) {
                    long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
                    XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
                    if (stat == null) {
                        stat = new XmitTimeStat();
                        XmitTimeStat stat2 = this.xmit_time_stats.putIfAbsent(key, stat);
                        if (stat2 != null) {
                            stat = stat2;
                        }
                    }
                    stat.xmit_rsps_received.incrementAndGet();
                }
                if (this.stats) {
                    ++this.xmit_rsps_received;
                    NAKACK.updateStats(this.received, msg.getSrc(), 0, 1, 0);
                }
                this.up(new Event(1, wrapped_msg));
                if (!this.rebroadcasting) break block12;
                Digest tmp = this.getDigest();
                this.rebroadcast_digest_lock.lock();
                try {
                    cancel_rebroadcasting = tmp.isGreaterThanOrEqual(this.rebroadcast_digest);
                }
                finally {
                    this.rebroadcast_digest_lock.unlock();
                }
                if (cancel_rebroadcasting) {
                    this.cancelRebroadcasting();
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block12;
                this.log.error("failed reading retransmitted message", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebroadcastMessages() {
        long sleep = this.max_rebroadcast_timeout / 3L;
        long wait_time = this.max_rebroadcast_timeout;
        long start = System.currentTimeMillis();
        while (wait_time > 0L) {
            Map<Address, Digest.Entry> their_digest;
            this.rebroadcast_digest_lock.lock();
            try {
                if (this.rebroadcast_digest == null) {
                    return;
                }
                their_digest = this.rebroadcast_digest.getSenders();
            }
            finally {
                this.rebroadcast_digest_lock.unlock();
            }
            Digest my_digest = this.getDigest();
            boolean xmitted = false;
            for (Map.Entry<Address, Digest.Entry> entry : their_digest.entrySet()) {
                long my_high;
                long their_high;
                Address sender = entry.getKey();
                Digest.Entry their_entry = entry.getValue();
                Digest.Entry my_entry = my_digest.get(sender);
                if (my_entry == null || (their_high = their_entry.getHighest()) <= (my_high = my_entry.getHighest())) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("sending XMIT request to " + sender + " for messages " + my_high + " - " + their_high);
                }
                this.retransmit(my_high, their_high, sender, true);
                xmitted = true;
            }
            if (!xmitted) {
                return;
            }
            this.rebroadcast_lock.lock();
            try {
                my_digest = this.getDigest();
                this.rebroadcast_digest_lock.lock();
                try {
                    if (!this.rebroadcasting || my_digest.isGreaterThanOrEqual(this.rebroadcast_digest)) {
                        this.rebroadcast_digest_lock.unlock();
                        this.rebroadcast_lock.unlock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.rebroadcast_digest_lock.unlock();
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            this.rebroadcast_digest_lock.unlock();
            this.rebroadcast_done.await(sleep, TimeUnit.MILLISECONDS);
            wait_time -= System.currentTimeMillis() - start;
        }
    }

    private void adjustReceivers(List<Address> new_members) {
        for (Address member : this.xmit_table.keySet()) {
            if (new_members.contains(member) || this.local_addr != null && this.local_addr.equals(member)) continue;
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.remove(member);
            win.destroy();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("removed " + member + " from xmit_table (not member anymore)");
        }
    }

    public Digest getDigest() {
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>();
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address sender = (Address)entry.getKey();
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            long low = win.getLowestSeen();
            long highest_delivered = win.getHighestDelivered();
            long highest_received = win.getHighestReceived();
            map.put(sender, new Digest.Entry(low, highest_delivered, highest_received));
        }
        return new Digest(map);
    }

    private void setDigest(Digest digest) {
        this.setDigest(digest, false);
    }

    private void mergeDigest(Digest digest) {
        this.setDigest(digest, true);
    }

    private void overwriteDigest(Digest digest) {
        if (digest == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("\n[overwriteDigest()]\n");
        sb.append("existing digest:  " + this.getDigest()).append("\nnew digest:       " + digest);
        for (Map.Entry<Address, Digest.Entry> entry : digest.getSenders().entrySet()) {
            Address sender = entry.getKey();
            Digest.Entry val = entry.getValue();
            if (sender == null || val == null) continue;
            long highest_delivered_seqno = val.getHighestDeliveredSeqno();
            long low_seqno = val.getLow();
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(sender);
            if (win != null) {
                win.destroy();
                this.xmit_table.remove(sender);
            }
            win = this.createNakReceiverWindow(sender, highest_delivered_seqno, low_seqno);
            this.xmit_table.put(sender, win);
        }
        sb.append("\n").append("resulting digest: " + this.getDigest());
        this.digest_history.add(sb.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug(sb.toString());
        }
    }

    private void setDigest(Digest digest, boolean merge) {
        if (digest == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(merge ? "\n[mergeDigest()]\n" : "\n[setDigest()]\n");
        sb.append("existing digest:  " + this.getDigest()).append("\nnew digest:       " + digest);
        for (Map.Entry<Address, Digest.Entry> entry : digest.getSenders().entrySet()) {
            Address sender = entry.getKey();
            Digest.Entry val = entry.getValue();
            if (sender == null || val == null) continue;
            long highest_delivered_seqno = val.getHighestDeliveredSeqno();
            long low_seqno = val.getLow();
            NakReceiverWindow win = (NakReceiverWindow)this.xmit_table.get(sender);
            if (win != null) {
                if (!merge || this.local_addr != null && this.local_addr.equals(sender) || win.getHighestDelivered() >= highest_delivered_seqno) continue;
                win.destroy();
                this.xmit_table.remove(sender);
            }
            win = this.createNakReceiverWindow(sender, highest_delivered_seqno, low_seqno);
            this.xmit_table.put(sender, win);
        }
        sb.append("\n").append("resulting digest: " + this.getDigest());
        this.digest_history.add(sb.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug(sb.toString());
        }
    }

    private NakReceiverWindow createNakReceiverWindow(Address sender, long initial_seqno, long lowest_seqno) {
        NakReceiverWindow win = new NakReceiverWindow(this.local_addr, sender, this, initial_seqno, lowest_seqno, this.timer, this.use_range_based_retransmitter);
        if (this.use_stats_for_retransmission) {
            win.setRetransmitTimeouts(new ActualInterval(sender));
        } else if (this.exponential_backoff > 0L) {
            win.setRetransmitTimeouts(new ExponentialInterval(this.exponential_backoff));
        } else {
            win.setRetransmitTimeouts(new StaticInterval(this.retransmit_timeouts));
        }
        win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
        win.setMaxXmitBufSize(this.max_xmit_buf_size);
        if (this.stats) {
            win.setListener(this);
        }
        return win;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpXmitStats(String filename) throws IOException {
        FileWriter out = new FileWriter(filename);
        try {
            TreeMap<Long, XmitTimeStat> map = new TreeMap<Long, XmitTimeStat>(this.xmit_time_stats);
            out.write("time (secs)  gaps-detected  xmit-reqs-sent  xmit-reqs-received  xmit-rsps-sent  xmit-rsps-received  missing-msgs-received\n\n");
            for (Map.Entry<Long, XmitTimeStat> entry : map.entrySet()) {
                StringBuilder sb = new StringBuilder();
                XmitTimeStat stat = entry.getValue();
                sb.append(entry.getKey()).append("  ");
                sb.append(stat.gaps_detected).append("  ");
                sb.append(stat.xmit_reqs_sent).append("  ");
                sb.append(stat.xmit_reqs_received).append("  ");
                sb.append(stat.xmit_rsps_sent).append("  ");
                sb.append(stat.xmit_rsps_received).append("  ");
                sb.append(stat.missing_msgs_received).append("\n");
                out.write(sb.toString());
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    private void stable(Digest digest) {
        if (this.members == null || this.local_addr == null || digest == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("members, local_addr or digest are null !");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("received stable digest " + digest);
        }
        this.stability_msgs.add(digest);
        for (Map.Entry<Address, Digest.Entry> entry : digest.getSenders().entrySet()) {
            Address sender = entry.getKey();
            if (sender == null) continue;
            Digest.Entry val = entry.getValue();
            long high_seqno_delivered = val.getHighestDeliveredSeqno();
            long high_seqno_received = val.getHighestReceivedSeqno();
            NakReceiverWindow recv_win = (NakReceiverWindow)this.xmit_table.get(sender);
            if (recv_win != null) {
                long my_highest_rcvd = recv_win.getHighestReceived();
                long stability_highest_rcvd = high_seqno_received;
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + '#' + stability_highest_rcvd);
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                }
            }
            if ((high_seqno_delivered -= (long)this.gc_lag) < 0L) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("deleting msgs <= " + high_seqno_delivered + " from " + sender);
            }
            if (recv_win == null) continue;
            recv_win.stable(high_seqno_delivered);
        }
    }

    @Override
    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        this.retransmit(first_seqno, last_seqno, sender, false);
    }

    protected void retransmit(long first_seqno, long last_seqno, Address sender, boolean multicast_xmit_request) {
        ConcurrentMap tmp2;
        Address random_member;
        Address dest = sender;
        if (multicast_xmit_request || this.use_mcast_xmit_req) {
            dest = null;
        } else if (this.xmit_from_random_member && !this.local_addr.equals(sender) && (random_member = (Address)Util.pickRandomElement(this.members)) != null && !this.local_addr.equals(random_member)) {
            dest = random_member;
            if (this.log.isTraceEnabled()) {
                this.log.trace("picked random member " + dest + " to send XMIT request to");
            }
        }
        NakAckHeader hdr = NakAckHeader.createXmitRequestHeader(first_seqno, last_seqno, sender);
        Message retransmit_msg = new Message(dest, null, null);
        retransmit_msg.setFlag((byte)1);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + dest);
        }
        retransmit_msg.putHeader(this.id, hdr);
        ConcurrentMap<Long, Long> tmp = (ConcurrentHashMap<Long, Long>)this.xmit_stats.get(sender);
        if (tmp == null && (tmp2 = (ConcurrentMap)this.xmit_stats.putIfAbsent(sender, tmp = new ConcurrentHashMap<Long, Long>())) != null) {
            tmp = tmp2;
        }
        for (long seq = first_seqno; seq < last_seqno; ++seq) {
            tmp.putIfAbsent(seq, System.currentTimeMillis());
        }
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                XmitTimeStat stat2 = this.xmit_time_stats.putIfAbsent(key, stat);
                if (stat2 != null) {
                    stat = stat2;
                }
            }
            stat.xmit_reqs_sent.addAndGet((int)(last_seqno - first_seqno + 1L));
        }
        this.down_prot.down(new Event(1, retransmit_msg));
        if (this.stats) {
            this.xmit_reqs_sent += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.sent, sender, 1, 0, 0);
        }
        this.xmit_history.add(sender + ": " + first_seqno + "-" + last_seqno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void missingMessageReceived(long seqno, Address original_sender) {
        Long timestamp;
        ConcurrentMap tmp = (ConcurrentMap)this.xmit_stats.get(original_sender);
        if (tmp != null && (timestamp = (Long)tmp.remove(seqno)) != null) {
            BoundedList list2;
            long diff = System.currentTimeMillis() - timestamp;
            BoundedList<Long> list = (BoundedList<Long>)this.xmit_times_history.get(original_sender);
            if (list == null && (list2 = this.xmit_times_history.putIfAbsent(original_sender, list = new BoundedList<Long>(this.xmit_history_max_size))) != null) {
                list = list2;
            }
            list.add(diff);
            Map<Address, Double> map = this.smoothed_avg_xmit_times;
            synchronized (map) {
                Double smoothed_avg = this.smoothed_avg_xmit_times.get(original_sender);
                if (smoothed_avg == null) {
                    smoothed_avg = 30.0;
                }
                smoothed_avg = (smoothed_avg * 0.9 + (double)diff) / 2.0;
                smoothed_avg = smoothed_avg * 1.1;
                this.smoothed_avg_xmit_times.put(original_sender, smoothed_avg);
            }
        }
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                XmitTimeStat stat2 = this.xmit_time_stats.putIfAbsent(key, stat);
                if (stat2 != null) {
                    stat = stat2;
                }
            }
            stat.missing_msgs_received.incrementAndGet();
        }
        if (this.stats) {
            ++this.missing_msgs_received;
            NAKACK.updateStats(this.received, original_sender, 0, 0, 1);
        }
    }

    @Override
    public void messageGapDetected(long from, long to, Address src) {
        if (this.xmit_time_stats != null) {
            long key = (System.currentTimeMillis() - this.xmit_time_stats_start) / 1000L;
            XmitTimeStat stat = (XmitTimeStat)this.xmit_time_stats.get(key);
            if (stat == null) {
                stat = new XmitTimeStat();
                XmitTimeStat stat2 = this.xmit_time_stats.putIfAbsent(key, stat);
                if (stat2 != null) {
                    stat = stat2;
                }
            }
            stat.gaps_detected.addAndGet((int)(to - from + 1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.seqno_lock.lock();
        try {
            this.seqno = 0L;
        }
        finally {
            this.seqno_lock.unlock();
        }
        for (NakReceiverWindow win : this.xmit_table.values()) {
            win.destroy();
        }
        this.xmit_table.clear();
        this.undelivered_msgs.set(0);
    }

    @ManagedOperation(description="TODO")
    public String printMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.xmit_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            NakReceiverWindow win = (NakReceiverWindow)entry.getValue();
            ret.append(addr).append(": ").append(win.toString()).append('\n');
        }
        return ret.toString();
    }

    @ManagedOperation(description="TODO")
    public String printRetransmissionAvgs() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_times_history.entrySet()) {
            Address sender = (Address)entry.getKey();
            BoundedList list = (BoundedList)entry.getValue();
            long tmp = 0L;
            int i = 0;
            for (Long val : list) {
                tmp += val.longValue();
                ++i;
            }
            double avg = i > 0 ? (double)(tmp / (long)i) : -1.0;
            sb.append(sender).append(": ").append(avg).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="TODO")
    public String printSmoothedRetransmissionAvgs() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Double> entry : this.smoothed_avg_xmit_times.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="TODO")
    public String printRetransmissionTimes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.xmit_times_history.entrySet()) {
            Address sender = (Address)entry.getKey();
            BoundedList list = (BoundedList)entry.getValue();
            sb.append(sender).append(": ").append(list).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Prints the last N retransmission requests")
    public String printXmitHistory() {
        StringBuilder sb = new StringBuilder();
        for (String req : this.xmit_history) {
            sb.append(req).append("\n");
        }
        return sb.toString();
    }

    @ManagedAttribute
    public double getTotalAverageRetransmissionTime() {
        long total = 0L;
        int i = 0;
        for (BoundedList list : this.xmit_times_history.values()) {
            for (Long val : list) {
                total += val.longValue();
                ++i;
            }
        }
        return i > 0 ? (double)(total / (long)i) : -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public double getTotalAverageSmoothedRetransmissionTime() {
        double total = 0.0;
        int cnt = 0;
        Map<Address, Double> map = this.smoothed_avg_xmit_times;
        synchronized (map) {
            for (Double val : this.smoothed_avg_xmit_times.values()) {
                if (val == null) continue;
                total += val.doubleValue();
                ++cnt;
            }
        }
        return cnt > 0 ? total / (double)cnt : -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSmoothedAverageRetransmissionTime(Address sender) {
        Map<Address, Double> map = this.smoothed_avg_xmit_times;
        synchronized (map) {
            Double retval = this.smoothed_avg_xmit_times.get(sender);
            if (retval == null) {
                retval = 30.0;
                this.smoothed_avg_xmit_times.put(sender, retval);
            }
            return retval;
        }
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (String key : keys) {
            if (key.equals("digest-history")) {
                retval.put(key, this.printDigestHistory());
            }
            if (!key.equals("dump-digest")) continue;
            retval.put(key, "\n" + this.printMessages());
        }
        return retval;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"digest-history", "dump-digest"};
    }

    static class StatsEntry {
        long xmit_reqs;
        long xmit_rsps;
        long missing_msgs_rcvd;

        StatsEntry() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.xmit_reqs).append(" xmit_reqs").append(", ").append(this.xmit_rsps).append(" xmit_rsps");
            sb.append(", ").append(this.missing_msgs_rcvd).append(" missing msgs");
            return sb.toString();
        }
    }

    private class ActualInterval
    implements Interval {
        private final Address sender;

        public ActualInterval(Address sender) {
            this.sender = sender;
        }

        @Override
        public long next() {
            return (long)NAKACK.this.getSmoothedAverageRetransmissionTime(this.sender);
        }

        @Override
        public Interval copy() {
            return this;
        }
    }

    private static class XmitTimeStat {
        final AtomicInteger gaps_detected = new AtomicInteger(0);
        final AtomicInteger xmit_reqs_sent = new AtomicInteger(0);
        final AtomicInteger xmit_reqs_received = new AtomicInteger(0);
        final AtomicInteger xmit_rsps_sent = new AtomicInteger(0);
        final AtomicInteger xmit_rsps_received = new AtomicInteger(0);
        final AtomicInteger missing_msgs_received = new AtomicInteger(0);

        private XmitTimeStat() {
        }
    }
}

