/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.AckMcastSenderWindow;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.Util;

@Experimental
@Unsupported
public class SMACK
extends Protocol
implements AckMcastSenderWindow.RetransmitCommand {
    @Property(converter=PropertyConverters.LongArray.class)
    long[] timeout = new long[]{1000L, 2000L, 3000L};
    @Property
    int max_xmits = 10;
    final Set<Address> members = new LinkedHashSet<Address>();
    AckMcastSenderWindow sender_win = null;
    final Map<Address, AckReceiverWindow> receivers = new ConcurrentHashMap<Address, AckReceiverWindow>();
    final Map<Address, Integer> xmit_table = new ConcurrentHashMap<Address, Integer>();
    Address local_addr = null;
    long seqno = 1L;
    final Lock lock = new ReentrantLock();
    long vid = 1L;
    @Property
    boolean print_local_addr = true;

    @Override
    public void stop() {
        if (this.sender_win != null) {
            this.sender_win.stop();
            this.sender_win = null;
        }
        for (AckReceiverWindow win : this.receivers.values()) {
            win.reset();
        }
        this.receivers.clear();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 9: {
                if (this.log.isInfoEnabled()) {
                    this.log.info("removing suspected member " + evt.getArg());
                }
                this.removeMember((Address)evt.getArg());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null) break;
                Address sender = msg.getSrc();
                SmackHeader hdr = (SmackHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        Message tmp_msg;
                        AckReceiverWindow win;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("received #" + hdr.seqno + " from " + sender);
                        }
                        if ((win = this.receivers.get(sender)) == null) {
                            this.addMember(sender);
                            win = new AckReceiverWindow(hdr.seqno);
                            this.receivers.put(sender, win);
                        }
                        boolean added = win.add(hdr.seqno, msg);
                        Message ack_msg = new Message(sender);
                        ack_msg.putHeader(this.id, new SmackHeader(2, hdr.seqno));
                        this.down_prot.down(new Event(1, ack_msg));
                        if (msg.isFlagSet((byte)1) && added) {
                            this.up_prot.up(new Event(1, msg));
                        }
                        while ((tmp_msg = win.remove()) != null) {
                            if (tmp_msg.isFlagSet((byte)1)) continue;
                            this.up_prot.up(new Event(1, tmp_msg));
                        }
                        return null;
                    }
                    case 2: {
                        this.addMember(msg.getSrc());
                        this.sender_win.ack(hdr.seqno, msg.getSrc());
                        this.sender_win.clearStableMessages();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("received ack for #" + hdr.seqno + " from " + msg.getSrc());
                        }
                        return null;
                    }
                    case 3: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("received join announcement by " + msg.getSrc());
                        }
                        if (!this.containsMember(sender)) {
                            Message join_rsp = new Message(sender);
                            join_rsp.putHeader(this.id, new SmackHeader(3, -1L));
                            this.down_prot.down(new Event(1, join_rsp));
                        }
                        this.addMember(sender);
                        return null;
                    }
                    case 4: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("received leave announcement by " + msg.getSrc());
                        }
                        this.removeMember(sender);
                        return null;
                    }
                }
                if (!this.log.isWarnEnabled()) break;
                this.log.warn("detected SmackHeader with invalid type: " + hdr);
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 4: {
                Message leave_msg = new Message();
                leave_msg.putHeader(this.id, new SmackHeader(4, -1L));
                this.down_prot.down(new Event(1, leave_msg));
                Util.sleep(100L);
                this.sender_win.stop();
                break;
            }
            case 2: {
                Object ret = this.down_prot.down(evt);
                this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, new StaticInterval(this.timeout));
                Message join_msg = new Message();
                join_msg.putHeader(this.id, new SmackHeader(3, -1L));
                this.down_prot.down(new Event(1, join_msg));
                return ret;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null || msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.lock.lock();
                try {
                    long msg_id = this.seqno;
                    msg.putHeader(this.id, new SmackHeader(1, msg_id));
                    this.sender_win.add(msg_id, msg, new Vector<Address>(this.members));
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("sending mcast #" + msg_id);
                    }
                    ++this.seqno;
                    break;
                }
                finally {
                    this.lock.unlock();
                }
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.addMember(this.local_addr);
                if (!this.print_local_addr) break;
                System.out.println("\n-------------------------------------------------------\nGMS: address is " + this.local_addr + "\n-------------------------------------------------------");
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public void retransmit(long seqno, Message msg, Address dest) {
        msg.setDest(dest);
        if (this.log.isInfoEnabled()) {
            this.log.info(seqno + ", msg=" + msg);
        }
        this.down_prot.down(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(Address mbr) {
        Vector<Address> tmp = null;
        Set<Address> set = this.members;
        synchronized (set) {
            if (this.members.add(mbr)) {
                tmp = new Vector<Address>(this.members);
            }
        }
        if (tmp != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("added " + mbr + ", members=" + tmp);
            }
            View new_view = new View(new ViewId(this.local_addr, this.vid++), tmp);
            this.up_prot.up(new Event(6, new_view));
            this.down_prot.down(new Event(6, new_view));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMember(Address mbr) {
        Vector<Address> tmp = null;
        Set<Address> set = this.members;
        synchronized (set) {
            if (this.members.remove(mbr)) {
                tmp = new Vector<Address>(this.members);
            }
        }
        if (tmp != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removed " + mbr + ", members=" + tmp);
            }
            View new_view = new View(new ViewId(this.local_addr, this.vid++), tmp);
            this.up_prot.up(new Event(6, new_view));
            this.down_prot.down(new Event(6, new_view));
            if (this.sender_win != null) {
                this.sender_win.remove(mbr);
            }
            for (Map.Entry<Address, AckReceiverWindow> entry : this.receivers.entrySet()) {
                Address member = entry.getKey();
                if (this.members.contains(member)) continue;
                AckReceiverWindow win = entry.getValue();
                win.reset();
            }
            this.receivers.keySet().retainAll(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsMember(Address mbr) {
        Set<Address> set = this.members;
        synchronized (set) {
            return this.members.contains(mbr);
        }
    }

    public static class SmackHeader
    extends Header {
        public static final byte MCAST = 1;
        public static final byte ACK = 2;
        public static final byte JOIN_ANNOUNCEMENT = 3;
        public static final byte LEAVE_ANNOUNCEMENT = 4;
        byte type = 0;
        long seqno = -1L;

        public SmackHeader() {
        }

        public SmackHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        @Override
        public int size() {
            return 9;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.seqno = in.readLong();
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "MCAST";
                }
                case 2: {
                    return "ACK";
                }
                case 3: {
                    return "JOIN_ANNOUNCEMENT";
                }
                case 4: {
                    return "LEAVE_ANNOUNCEMENT";
                }
            }
            return "<unknown>";
        }
    }
}

