/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.jdesktop.jxlayer.JXGlassPane;
import org.jdesktop.jxlayer.LayerLayout;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.item.LayerItemChangeEvent;
import org.jdesktop.jxlayer.plaf.item.LayerItemListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JXLayer<V extends JComponent>
extends JComponent
implements Scrollable,
LayerItemListener,
PropertyChangeListener {
    private V view;
    private JComponent glassPane;
    private boolean isPainting;
    private static final LayerLayout sharedLayoutInstance = new LayerLayout();
    private final InputContext inputContext = new LayerInputContext();
    private boolean isProxyInputContextEnabled = true;

    public JXLayer() {
        this(null);
    }

    public JXLayer(V v) {
        this(v, null);
    }

    public JXLayer(V v, LayerUI<V> layerUI) {
        this.setLayout(sharedLayoutInstance);
        this.setGlassPane(new JXGlassPane());
        this.setView(v);
        this.setUI(layerUI);
    }

    public V getView() {
        return this.view;
    }

    public void setView(V v) {
        V v2 = this.getView();
        if (v2 != null) {
            super.remove((Component)v2);
        }
        if (v != null) {
            super.addImpl((Component)v, null, this.getComponentCount());
        }
        this.view = v;
        this.firePropertyChange("view", v2, v);
        this.revalidate();
        this.repaint();
    }

    public void setUI(LayerUI<V> layerUI) {
        if (this.isValidUI()) {
            this.disableEvents(this.getUI().getLayerEventMask());
        }
        super.setUI(layerUI);
        if (this.isValidUI()) {
            this.getGlassPane().setVisible(true);
            this.enableEvents(layerUI.getLayerEventMask());
        } else {
            this.getGlassPane().setVisible(false);
        }
    }

    @Override
    public LayerUI<V> getUI() {
        return (LayerUI)this.ui;
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("GlassPane can't be set to null");
        }
        JComponent jComponent2 = this.getGlassPane();
        if (jComponent2 != null) {
            super.remove(jComponent2);
        }
        super.addImpl(jComponent, null, 0);
        this.glassPane = jComponent;
        this.firePropertyChange("glassPane", jComponent2, jComponent);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("Component is not instance of JComponent");
        }
        this.setView((JComponent)component);
    }

    @Override
    public void remove(Component component) {
        if (component == this.getView()) {
            this.view = null;
        } else if (component == this.getGlassPane()) {
            throw new IllegalArgumentException("GlassPane can't be removed");
        }
        super.remove(component);
    }

    @Override
    public void removeAll() {
        this.setView(null);
    }

    private boolean isValidUI() {
        return this.getUI() != null && this.getUI().isEnabled();
    }

    @Override
    public void paint(Graphics graphics) {
        LayerUI<V> layerUI = this.getUI();
        if (!this.isPainting && graphics instanceof Graphics2D && this.isValidUI() && this.getWidth() > 0 && this.getHeight() > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            this.isPainting = true;
            layerUI.paint(graphics2D, this);
            this.isPainting = false;
            graphics2D.dispose();
        } else {
            super.paint(graphics);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.glassPane.isVisible();
    }

    @Override
    public void layerItemChanged(LayerItemChangeEvent layerItemChangeEvent) {
        Shape shape = layerItemChangeEvent.getClip(this.getWidth(), this.getHeight());
        if (shape != null) {
            this.repaint(shape.getBounds());
        } else {
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("enabled".equals(string)) {
            if (this.getUI().isEnabled()) {
                this.getGlassPane().setVisible(true);
                this.enableEvents(this.getUI().getLayerEventMask());
            } else {
                this.getGlassPane().setVisible(false);
                this.disableEvents(this.getUI().getLayerEventMask());
            }
        } else if ("layerEventMask".equals(string) && this.getUI().isEnabled()) {
            this.disableEvents((Long)propertyChangeEvent.getOldValue());
            this.enableEvents(this.getUI().getLayerEventMask());
        }
    }

    @Override
    public void updateUI() {
        if (this.isValidUI()) {
            this.getUI().updateUI(this);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.isValidUI()) {
            return this.getUI().contains(this, n, n2);
        }
        return n >= 0 && n < this.getWidth() && n2 >= 0 && n2 < this.getHeight();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getUI() != null) {
            return this.getUI().getPreferredScrollableViewportSize(this);
        }
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getUI() != null) {
            return this.getUI().getScrollableBlockIncrement(this, rectangle, n, n2);
        }
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getUI() != null) {
            return this.getUI().getScrollableTracksViewportHeight(this);
        }
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getUI() != null) {
            return this.getUI().getScrollableTracksViewportWidth(this);
        }
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getUI() != null) {
            return this.getUI().getScrollableUnitIncrement(this, rectangle, n, n2);
        }
        return 1;
    }

    public boolean isProxyInputContextEnabled() {
        return this.isProxyInputContextEnabled;
    }

    public void setProxyInputContextEnabled(boolean bl) {
        this.isProxyInputContextEnabled = bl;
    }

    @Override
    public InputContext getInputContext() {
        if (this.isProxyInputContextEnabled()) {
            return super.getInputContext() == null ? null : this.inputContext;
        }
        return super.getInputContext();
    }

    private class LayerInputContext
    extends InputContext {
        private LayerInputContext() {
        }

        public void dispatchEvent(AWTEvent aWTEvent) {
            if (JXLayer.this.isValidUI() && JXLayer.this.getUI().isEventEnabled(aWTEvent.getID()) && (aWTEvent instanceof InputEvent || aWTEvent instanceof FocusEvent)) {
                JXLayer.this.getUI().eventDispatched(aWTEvent, JXLayer.this);
            }
            JXLayer.super.getInputContext().dispatchEvent(aWTEvent);
        }

        public void dispose() {
            JXLayer.super.getInputContext().dispose();
        }

        public void endComposition() {
            JXLayer.super.getInputContext().endComposition();
        }

        public Object getInputMethodControlObject() {
            return JXLayer.super.getInputContext().getInputMethodControlObject();
        }

        public Locale getLocale() {
            return JXLayer.super.getInputContext().getLocale();
        }

        public boolean isCompositionEnabled() {
            return JXLayer.super.getInputContext().isCompositionEnabled();
        }

        public void reconvert() {
            JXLayer.super.getInputContext().reconvert();
        }

        public void removeNotify(Component component) {
            JXLayer.super.getInputContext().removeNotify(component);
        }

        public boolean selectInputMethod(Locale locale) {
            return JXLayer.super.getInputContext().selectInputMethod(locale);
        }

        public void setCharacterSubsets(Character.Subset[] subsetArray) {
            JXLayer.super.getInputContext().setCharacterSubsets(subsetArray);
        }

        public void setCompositionEnabled(boolean bl) {
            JXLayer.super.getInputContext().setCompositionEnabled(bl);
        }
    }
}

