/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.email.models.GroupEmailEntityModel;
import com.jurismarches.vradi.ui.email.models.UserEmailEntityModel;
import com.jurismarches.vradi.ui.email.renderers.EmailFormsListCellRenderer;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static com.jurismarches.vradi.VradiConstants.SessionStatus;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FormViewUI extends com.jurismarches.vradi.ui.email.EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GROUPS_FORM_FORM = "groupsForm.form";
    public static final String BINDING_GROUPS_FORM_SESSION = "groupsForm.session";
    public static final String BINDING_USERS_FORM_FORM = "usersForm.form";
    public static final String BINDING_USERS_FORM_SESSION = "usersForm.session";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdmziOHT6CI0ICAQWwBAroHKBBSoBAwCKRAwITFOGGPd8Sb7iPZXcvuaRA/AR+AvQ0SHRUiIKaggbxFxCioEXM3p3tGC7Ywi7Wvp15b96M39zrb5CRAk6skyAwhO8q5lBj6drq6h1zndbVDSrrgnHlCYg+qTSkazBste6lglO1ioaXYnhpwXO451J3B3q2AnmptmwqG5QqBcc6EXUpS9VWeDbgvmiytkQlsb788T39wnr+Kg0QcFQ3hK1MdUO1OxmoQJpZCgpYaYOUbOKuoQzB3DXUu0/fLdhEytvEoU/hGWQrMMiJQDIFJ3tvOeQI8QFXMFK86RBmL3iuwvSVxRkF03XPMdZ9waRDRL1BpbEhiMUMnxlU5xplTzgPGN1cWeQ8ZBpUkJVUSoYscHoXONIzxfCxGmW2sQMmJQgsdgPqujsqFu8T06YoeLxjxHITB2aEMZ2ZawGGiksVYlIbEQU9zCBOjW51UqGVm18Tns+lrqhgpttA7vpUbC2TJ1REY+nkatY9r58Pd8ZyvqQiLKMvjsRBAUc7WkI/Gm0/tg2TqkFG+HiNM6j9beF7GIrMO/6HeTVhGP01Nvr53de35aZj81j7UGLqjoVDJ3HhcSr0v6LgQGRXXzG7tEz4bA1yktq4reE2TiYIq8ZhFIf1Dmq4oeHGLSIbSJHJfnn/YezRpz2QLkPe9ohVJjp/EXKqIXAKnm0F/Op8qGjv5hCeI1obWknRANehMMdcm7l0iijcH9NX9EqAY5hMGENLi5n7+HO0+ma+OYoUSpvYNb09jsxDGIyqhesbb2biug5zSX3La29g0k6m9PcYj41eDM8zSb1m6jbZ3lawf84iikyZzLXQztioRpwLO9C/jJBwogfCLHX11oQtXPx/moHHsZ374Gi+Tvqi0dfT+jibzDDZE8OFf2g43hPDpb4ZLvfNcL0Lw2+A8r+meQcAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.FormViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Form bean;
    protected com.jurismarches.vradi.ui.email.QueryMakerViewUI< Group > groupsForm;
    protected com.jurismarches.vradi.entities.Session session;
    protected com.jurismarches.vradi.ui.email.QueryMakerViewUI< User > usersForm;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FormViewUI $EmailContentUI0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void openUI(VradiTreeNode node) {
        // Get datas
        getHandler().displayForm(this, node);
        Form formSelected = getContextValue(Form.class);
        setBean(formSelected);
    
        session = getHelper().getSessionToDisplay(node);
        updateSession(session);
    }
    
    public void updateSession(Session currentSession){
        setSession(currentSession);
    
        groupsForm.setSession(currentSession);
        usersForm.setSession(currentSession);
    
        java.util.List<User> userSending = EmailDataHelper.getUsersSendingConcernedBy(session, bean.getWikittyId());
        java.util.List<User> allUsers = getAdminHandler().getAllUsers();
        allUsers.removeAll(userSending);
        EmailFormsListCellRenderer emailFormsCellRenderer = new EmailFormsListCellRenderer();
        emailFormsCellRenderer.updateDatas(getSession(), getBean().getWikittyId());
        usersForm.init(true, getBean(), emailFormsCellRenderer, allUsers, userSending);
        usersForm.getQueryMakerForm().getList().setModel(new UserEmailEntityModel(emailFormsCellRenderer, session, getBean()));
    
        java.util.List<Group> groupSending = EmailDataHelper.getGroupsSendingConcernedBy(session, bean.getWikittyId());
        java.util.List<Group> allGroups = getAdminHandler().getAllGroups();
        allGroups.removeAll(groupSending);
        groupsForm.init(true, getBean(), emailFormsCellRenderer, allGroups, groupSending);
        groupsForm.getQueryMakerForm().getList().setModel(new GroupEmailEntityModel(emailFormsCellRenderer, session, getBean()));
    
        usersForm.setEnabled(sessionCanBeSent());
        groupsForm.setEnabled(sessionCanBeSent());
    }
    
    protected boolean sessionCanBeSent() {
        if (session == null) {
            return false;
        }
        return SessionStatus.isActive(session);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FormViewUI() {
        super();
        $initialize();
    }

    public FormViewUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Form getBean() {
        return bean;
    }

    public com.jurismarches.vradi.ui.email.QueryMakerViewUI< Group > getGroupsForm() {
        return groupsForm;
    }

    public com.jurismarches.vradi.entities.Session getSession() {
        return session;
    }

    public com.jurismarches.vradi.ui.email.QueryMakerViewUI< User > getUsersForm() {
        return usersForm;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createGroupsForm() {
        $objectMap.put("groupsForm", groupsForm = new com.jurismarches.vradi.ui.email.QueryMakerViewUI< Group >(this));
        
        groupsForm.setName("groupsForm");
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createUsersForm() {
        $objectMap.put("usersForm", usersForm = new com.jurismarches.vradi.ui.email.QueryMakerViewUI< User >(this));
        
        usersForm.setName("usersForm");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $EmailContentUI0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(groupsForm, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(usersForm, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        groupsForm.setClazz(Group.class);
        groupsForm.setEnabled(sessionCanBeSent());
        usersForm.setClazz(User.class);
        usersForm.setEnabled(sessionCanBeSent());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$EmailContentUI0", this);
        createSession();
        createBean();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.formGroupTitle"));
        createGroupsForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.formUserTitle"));
        createUsersForm();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_FORM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setForm(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setSession(getSession());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_FORM, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                usersForm.setForm(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                usersForm.setSession(getSession());
            }
        });
    }

}