/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.thesaurus.helpers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiTreeHelper;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.RootThesaurusNodeLoadors;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.ThesaurusNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;

public class ThesaurusTreeHelper
extends VradiTreeHelper {
    private static final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    protected RootThesaurus rootThesaurus;
    protected Thesaurus thesaurus;
    protected boolean listening = true;

    public ThesaurusTreeHelper(VradiDataProvider dataProvider) {
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, RootThesaurus rootThesaurus) {
        this.rootThesaurus = rootThesaurus;
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, Thesaurus thesaurus) {
        this.thesaurus = thesaurus;
        this.init(dataProvider);
    }

    protected void init(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public TreeModel createTreeModel() {
        VradiTreeNode root;
        if (this.thesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] thesaurus " + this.thesaurus.getName()));
            }
            root = new VradiTreeNode(Thesaurus.class, this.thesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else if (this.rootThesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] root thesaurus " + this.rootThesaurus.getName()));
            }
            root = new VradiTreeNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"[Root creation] all root thesaurus");
            }
            root = new VradiTreeNode(String.class, "Root node", null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(RootThesaurusNodeLoadors.class));
        }
        DefaultTreeModel model = this.createModel(root, new Object[0]);
        root.populateChilds(this.getBridge(), this.getDataProvider());
        this.registerLoadedIds(root);
        return model;
    }

    public void tryToSelect(List<Thesaurus> thesaurus) {
        this.tryToSelect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToSelect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Try to select, ids are null");
            }
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (String id : thesaurusIds) {
            if (id.equals(((VradiTreeNode)this.getRootNode()).getId())) continue;
            VradiTreeNode rootNode = (VradiTreeNode)this.getRootNode();
            VradiTreeNode nodeFound = (VradiTreeNode)this.findNode((NavNode)rootNode, new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(List<Thesaurus> thesaurus) {
        this.tryToUnselect((Collection<String>)this.extractIds(thesaurus));
    }

    public void tryToUnselect(Collection<String> thesaurusIds) {
        if (thesaurusIds == null) {
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (String id : thesaurusIds) {
            VradiTreeNode nodeFound = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{id});
            if (nodeFound == null) continue;
            nodes.add(nodeFound);
        }
        this.unSelectNodes(nodes);
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                if (bean == null) continue;
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    public static RootThesaurus getRootThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    protected void refresh(VradiTreeNode node) {
        if (node == null) {
            return;
        }
        ((NavTreeBridge)this.getBridge()).nodeChanged((TreeNode)((Object)node));
    }

    @Override
    public void putWikitty(final String wikittyId, Set<String> wikittyExtensions) {
        if (wikittyExtensions.contains("Thesaurus")) {
            final Thesaurus thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
            if (thesaurusConcerned == null) {
                return;
            }
            if (this.idsLoaded.contains(thesaurusConcerned.getParent())) {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        VradiTreeNode existingNode = (VradiTreeNode)ThesaurusTreeHelper.this.findNode(ThesaurusTreeHelper.this.getRootNode(), new String[]{wikittyId});
                        if (existingNode != null) {
                            VradiTreeNode parent = (VradiTreeNode)existingNode.getParent();
                            String newParentId = thesaurusConcerned.getParent();
                            if (parent != null && !parent.getId().equals(newParentId)) {
                                VradiTreeNode newParentNode = (VradiTreeNode)ThesaurusTreeHelper.this.findNode(ThesaurusTreeHelper.this.getRootNode(), new String[]{newParentId});
                                ((NavTreeBridge)ThesaurusTreeHelper.this.getBridge()).removeNodeFromParent((NavTreeNode)existingNode);
                                if (ThesaurusTreeHelper.this.findNode((NavNode)newParentNode, new String[]{wikittyId}) == null) {
                                    ThesaurusTreeHelper.this.insertNode((NavNode)newParentNode, (NavNode)existingNode);
                                }
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                                }
                                ThesaurusTreeHelper.this.refresh(existingNode);
                            }
                            return;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
                        }
                        VradiTreeNode parentNode = (VradiTreeNode)ThesaurusTreeHelper.this.findNode(ThesaurusTreeHelper.this.getRootNode(), new String[]{thesaurusConcerned.getParent()});
                        VradiTreeNode newNode = ((ThesaurusNodeLoadors)NavHelper.getChildLoador(ThesaurusNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)ThesaurusTreeHelper.this.getDataProvider());
                        if (ThesaurusTreeHelper.this.findNode((NavNode)parentNode, new String[]{wikittyId}) == null) {
                            ThesaurusTreeHelper.this.insertNode((NavNode)parentNode, (NavNode)newNode);
                        }
                    }
                });
            }
        }
        if (wikittyExtensions.contains("RootThesaurus")) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    VradiTreeNode existingNode = (VradiTreeNode)ThesaurusTreeHelper.this.findNode(ThesaurusTreeHelper.this.getRootNode(), new String[]{wikittyId});
                    if (existingNode != null) {
                        ThesaurusTreeHelper.this.refresh(existingNode);
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Refresh root thesaurus : " + wikittyId));
                    }
                    VradiTreeNode newNode = ((RootThesaurusNodeLoadors)NavHelper.getChildLoador(RootThesaurusNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)ThesaurusTreeHelper.this.getDataProvider());
                    ThesaurusTreeHelper.this.insertNode(ThesaurusTreeHelper.this.getRootNode(), (NavNode)newNode);
                }
            });
        }
    }
}

