/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.renderers;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class SendingRenderer
extends DefaultListCellRenderer
implements WikittyServiceListener {
    protected Map<String, String> renderCache = new HashMap<String, String>();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        Sending sending = (Sending)value;
        String wikittyId = sending.getWikittyId();
        if (this.renderCache.containsKey(wikittyId)) {
            return super.getListCellRendererComponent((JList<?>)list, this.renderCache.get(wikittyId), index, isSelected, cellHasFocus);
        }
        String text = "";
        String userId = sending.getUser();
        if (userId != null) {
            User user = (User)proxy.restore(User.class, userId);
            Client client = (Client)proxy.restore(Client.class, user.getClient());
            text = client.getName() + " - " + user.getName();
        }
        this.renderCache.put(wikittyId, text);
        return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
    }

    public void putWikitty(WikittyServiceEvent event) {
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (!wikittyExtensions.contains("Sending")) continue;
            this.renderCache.remove(wikittyId);
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
    }

    public void removeExtension(WikittyServiceEvent event) {
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

