/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

public class EmailDataHelper {
    protected static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static Sending getSending(Session session, User user) {
        String id = user.getWikittyId();
        return EmailDataHelper.getSending(session, id);
    }

    public static Sending getSending(Session session, String id) {
        if (session == null) {
            return null;
        }
        Set sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return null;
        }
        ArrayList sendingIds = new ArrayList(sendingIdsSet);
        List sendings = EmailDataHelper.getProxy().restore(Sending.class, sendingIds);
        for (Sending sending : sendings) {
            if (sending == null || !id.equals(sending.getUser())) continue;
            return sending;
        }
        return null;
    }

    public static int getNbFormToSend(Session session, User bean) {
        Sending sending = EmailDataHelper.getSending(session, bean);
        Set formIds = null;
        if (sending != null) {
            formIds = sending.getForm();
        }
        return formIds == null ? 0 : formIds.size();
    }

    public static int getNbFormToSend(Session session, Group group) {
        ArrayList formIds = new ArrayList();
        for (String userId : group.getUser()) {
            Set formsIds;
            Sending sending = EmailDataHelper.getSending(session, userId);
            if (sending == null || (formsIds = sending.getForm()) == null) continue;
            formIds.addAll(formsIds);
        }
        return formIds.size();
    }

    public static String convertFormsToString(List<Form> forms) {
        List<String> objects = EmailDataHelper.extractObject(forms);
        return StringUtils.join(objects, (String)",\n");
    }

    public static <E extends BusinessEntity> String convertObjectBeanToString(List beans, Class<E> clazz) {
        ArrayList<BusinessEntity> casted = new ArrayList<BusinessEntity>();
        for (Object o : beans) {
            casted.add((BusinessEntity)o);
        }
        return EmailDataHelper.convertBeanToString(casted);
    }

    public static String convertBeanToString(List<? extends BusinessEntity> beans) {
        List<String> names = EmailDataHelper.extractNames(beans);
        return StringUtils.join(names, (String)",\n");
    }

    protected static List<String> extractObject(List<Form> forms) {
        ArrayList<String> objects = new ArrayList<String>();
        for (Form f : forms) {
            objects.add(f.getObjet());
        }
        return objects;
    }

    protected static List<String> extractNames(List<? extends BusinessEntity> beans) {
        ArrayList<String> beansAsNames = new ArrayList<String>();
        for (BusinessEntity businessEntity : beans) {
            beansAsNames.add(VradiHelper.getEntityName(businessEntity));
        }
        return beansAsNames;
    }
}

