/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferListUI extends javax.swing.JSplitPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADVANCED_SEARCH_COLLAPSED = "advancedSearchCollapsed";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_OFFER_LIST_TABLE_MODEL = "offerListTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.OfferListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean advancedSearchCollapsed;
    protected javax.swing.JTabbedPane editTabs;
    protected javax.swing.JButton exportButton;
    protected com.jurismarches.vradi.ui.offer.OfferTable listTable;
    protected OfferListUI offerList = this;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel offerListTableModel;
    protected javax.swing.JPanel paginationPanel;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected javax.swing.JPanel searchPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListHandler getHandler() {
        return getContextValue(OfferListHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return getContextValue(SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        final JTableHeader header = listTable.getTableHeader();
        header.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == MouseEvent.BUTTON1) {
                    // Get column selected
                    TableColumnModel columnModel = ((JTableHeader)e.getSource()).getColumnModel();
                    int columnIndex = columnModel.getColumnIndexAtX(e.getX());
                    TableColumn column = columnModel.getColumn(columnIndex);
    
                    final String fqName = offerListTableModel.getColumnFqName(columnIndex);
                    offerListTableModel.setAscending(!offerListTableModel.isAscending());
                    offerListTableModel.setFieldToSort(fqName);
                } 
            }
        });
    
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "offerListTableModel", offerListTableModel) {
           @Override
            public void processDataBinding() {
                if (offerListTableModel != null) {
                    getSearchHandler().executeQuery(offerList);
                }
            }
        };
      
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferListUI() {
        $initialize();
    }

    public OfferListUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__exportButton(java.awt.event.ActionEvent event) {
        getSearchHandler().exportToCSV(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAdvancedSearchCollapsed() {
        return advancedSearchCollapsed;
    }

    public javax.swing.JTabbedPane getEditTabs() {
        return editTabs;
    }

    public javax.swing.JButton getExportButton() {
        return exportButton;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getListTable() {
        return listTable;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getOfferListTableModel() {
        return offerListTableModel;
    }

    public javax.swing.JPanel getPaginationPanel() {
        return paginationPanel;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean isAdvancedSearchCollapsed() {
        return advancedSearchCollapsed !=null && advancedSearchCollapsed;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAdvancedSearchCollapsed(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.advancedSearchCollapsed;
        this.advancedSearchCollapsed = newValue;
        firePropertyChange(PROPERTY_ADVANCED_SEARCH_COLLAPSED, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setOfferListTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.offerListTableModel;
        this.offerListTableModel = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_TABLE_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToOfferList() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, JSplitPane.LEFT);
        add(editTabs, JSplitPane.RIGHT);
    }

    protected void addChildrenToPaginationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        paginationPanel.add(paginationUI, BorderLayout.NORTH);
        paginationPanel.add(exportButton, BorderLayout.SOUTH);
    }

    protected void createAdvancedSearchCollapsed() {
        $objectMap.put("advancedSearchCollapsed", advancedSearchCollapsed = false);
    }

    protected void createEditTabs() {
        $objectMap.put("editTabs", editTabs = new javax.swing.JTabbedPane());
        
        editTabs.setName("editTabs");
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new javax.swing.JButton());
        
        exportButton.setName("exportButton");
        exportButton.setText(_("vradi.export.cvs"));
        exportButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__exportButton"));
    }

    protected void createListTable() {
        $objectMap.put("listTable", listTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        listTable.setName("listTable");
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createOfferListTableModel() {
        $objectMap.put("offerListTableModel", offerListTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createPaginationPanel() {
        $objectMap.put("paginationPanel", paginationPanel = new javax.swing.JPanel());
        
        paginationPanel.setName("paginationPanel");
        paginationPanel.setLayout(new BorderLayout());
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferList();
        // inline complete setup of $JPanel0
        $JPanel0.add(searchPanel, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationPanel, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(listTable);
        addChildrenToPaginationPanel();
        
        // apply 16 property setters
        setDividerLocation(Integer.MAX_VALUE);
        setDividerSize(0);
        setOrientation(JSplitPane.VERTICAL_SPLIT);
        setResizeWeight(1);
        offerListTableModel.setNbFormsPerPage(10);
        offerListTableModel.setPageToShow(1);
        listTable.setAutoResizeMode(2);
        listTable.setColumnControlVisible(true);
        listTable.setColumnFactory(offerListColumnFactory);
        listTable.setGridColor(Color.GRAY);
        listTable.setHorizontalScrollEnabled(true);
        listTable.setModel(offerListTableModel);
        listTable.setShowGrid(true);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerList", this);
        createOfferListColumnFactory();
        createOfferListTableModel();
        createAdvancedSearchCollapsed();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createListTable();
        createPaginationPanel();
        createPaginationUI();
        createExportButton();
        createEditTabs();
        // inline creation of offerList
        setName("offerList");
        setOneTouchExpandable(true);
        setContinuousLayout(true);
        
        $completeSetup();
    }

}