/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.login;

import static org.nuiton.i18n.I18n._;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JOptionPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;

/**
 * Login and register user handler.
 * 
 * @author morin
 *         Date: 4 déc. 2009
 *         Time: 16:34:04
 */
public class LoginHandler {

    /** Log. */
    static private final Log log = LogFactory.getLog(LoginHandler.class);

    /** Empty password value. */
    private final static String EMPTY_PASSWORD = "null";

    /**
     * Storage service.
     * 
     * @return storage service
     */
    public VradiStorageService getVradiStorageService() {
        return VradiService.getVradiStorageService();
    }

    /**
     * Loguser action.
     * 
     * @param ui parent ui
     */
    public void logUser(LoginUI ui) {
        try {
            String login = ui.getLogin().getText().trim();
            String password = String.valueOf(ui.getPassword().getPassword()).trim();

            String md5Password = password.isEmpty() ? EMPTY_PASSWORD : StringUtil.encodeMD5(password);
            VradiUser user = getVradiStorageService().loginUser(login, md5Password);

            if (user != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Login failed for user " + login);
                }
                ui.setBean(user);
            } else {
                JOptionPane.showMessageDialog(ui, _("vradi.login.error.message"), _("vradi.login.error"),
                        JOptionPane.ERROR_MESSAGE);
                ui.getLogin().grabFocus();
            }
        } catch (VradiException eee) {
            JOptionPane.showMessageDialog(ui, _("vradi.login.error.message"), _("vradi.login.error"),
                    JOptionPane.ERROR_MESSAGE);
        }
    }

    /**
     * Show register UI.
     * 
     * @param ui parent ui.
     */
    public void register(LoginUI ui) {
        RegisterUI regUI = new RegisterUI(ui);
        regUI.setLocationRelativeTo(ui);
        regUI.setVisible(true);
    }

    /**
     * Register action.
     * 
     * @param ui parent ui
     */
    public void register(RegisterUI ui) {
        try {
            String beanPassword = ui.getBean().getPassword();
            String repeatPassword = String.valueOf(ui.getRepeatPassword().getPassword());
            
            if (beanPassword != null && beanPassword.equals(repeatPassword)) {
                if (beanPassword.isEmpty()) {
                    ui.getBean().setPassword(EMPTY_PASSWORD);
                } else {
                    ui.getBean().setPassword(StringUtil.encodeMD5(beanPassword.trim()));
                }
                VradiUser result = ui.getBean();
                result = getVradiStorageService().createUser(result);
                if (result == null) {
                    JOptionPane.showMessageDialog(ui, _("vradi.register.user.error.message"), _("vradi.register.user.error"),
                            JOptionPane.ERROR_MESSAGE);
                    ui.getLogin().grabFocus();
                    ui.getLogin().setBorder(BorderFactory.createLineBorder(Color.RED, 3));
                } else {
                    JOptionPane.showMessageDialog(ui, _("vradi.register.ok.message"), _("vradi.register.ok"),
                            JOptionPane.INFORMATION_MESSAGE);
                    ui.dispose();
                }
            } else {
                JOptionPane.showMessageDialog(ui, _("vradi.register.password.error.message"), _("vradi.register.password.error"),
                        JOptionPane.ERROR_MESSAGE);
                ui.getPassword().grabFocus();
                ui.getPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
                ui.getRepeatPassword().setBorder(BorderFactory.createLineBorder(Color.RED));
            }
        } catch (VradiException eee) {
            JOptionPane.showMessageDialog(ui, _("vradi.register.password.error.message"), _("vradi.register.password.error"),
                    JOptionPane.ERROR_MESSAGE);
        }
    }
}
