/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import org.apache.commons.lang.StringUtils;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailDataHelper {

    protected static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static Sending getSending(Session session, User user) {
        String id = user.getWikittyId();
        return getSending(session, id);
    }

    public static Sending getSending(Session session, String id) {
        if (session == null) {
            return null;
        }
        Set<String> sendingIdsSet = session.getSending();
        if (sendingIdsSet == null) {
            return null;
        }
        List<String> sendingIds = new ArrayList<String>(sendingIdsSet);
        List<Sending> sendings = getProxy().restore(Sending.class, sendingIds);
        for (Sending sending : sendings) {
            if (sending != null && id.equals(sending.getUser())) {

                return sending;
            }
        }
        return null;
    }

    public static int getNbFormToSend(Session session, User bean) {
        Sending sending = getSending(session, bean);
        Set<String> formIds = null;
        if (sending != null) {
            formIds = sending.getForm();
        }
        return formIds == null ? 0 : formIds.size();
    }

    public static int getNbFormToSend(Session session, Group group) {
        List<String> formIds = new ArrayList<String>();
        for (String userId : group.getUser()) {
            Sending sending = getSending(session, userId);
            if (sending != null) {
                Set<String> formsIds = sending.getForm();
                if (formsIds != null) {
                    formIds.addAll(formsIds);
                }
            }
        }
        return formIds.size();
    }


    public static String convertFormsToString(List<Form> forms) {

        List<String> objects = extractObject(forms);

        return StringUtils.join(objects, ",\n");
    }

    public static <E extends BusinessEntity> String convertObjectBeanToString(List beans, Class<E> clazz) {

        List<E> casted = new ArrayList<E>();
        for (Object o : beans) {
            casted.add((E)o);
        }

        return convertBeanToString(casted);
    }

    public static String convertBeanToString(List<? extends BusinessEntity> beans) {

        List<String> names = extractNames(beans);

        return StringUtils.join(names, ",\n");
    }

    protected static List<String> extractObject(List<Form> forms) {
        List<String> objects = new ArrayList<String>();
        for (Form f : forms) {
            objects.add(f.getObjet());
        }
        return objects;
    }
    protected static List<String> extractNames(List<? extends BusinessEntity> beans) {
        List<String> beansAsNames = new ArrayList<String>();
        for (BusinessEntity b : beans) {
            beansAsNames.add(VradiHelper.getEntityName(b));
        }
        return beansAsNames;
    }

}
