/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.FormViewUI;
import com.jurismarches.vradi.ui.email.SendingViewUI;
import com.jurismarches.vradi.ui.email.SessionViewUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;

import java.text.SimpleDateFormat;

/**
 *
 * @author sletellier
 * @version $Revision: 1155 $
 *
 * Last update : $Date: 2010-07-16 19:57:44 +0200 (ven. 16 juil. 2010) $
 * By : $Author: sletellier $
 */
public enum EmailBeanConstant {

    // Client
//    CLIENT(Client.class, SessionViewUI.class),
    // Group
    GROUP(Group.class, SessionViewUI.class),
    // User
    USER(User.class, SendingViewUI.class),
    // Form
    FORM(Form.class, FormViewUI.class),
    //Session$
    SESSION(Session.class, SessionViewUI.class);

    /**
     * Logger
     */
    private static Log log = LogFactory.getLog(EmailBeanConstant.class);
    
    protected Class<? extends BusinessEntity> beanClass;

    protected Class<? extends EmailContentUI> uiClass;

    private EmailBeanConstant(Class<? extends BusinessEntity> beanClass, Class<? extends EmailContentUI> uiClass) {
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public Class<? extends BusinessEntity> getBeanClass() {
        return beanClass;
    }

    public Class<? extends EmailContentUI> getUIClass() {
        return uiClass;
    }

    public static EmailBeanConstant getConstantByBeanClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())){
                return constant;
            }
        }
        return null;
    }

    public BusinessEntity getBean(VradiDataProvider provider, String id) {
        WikittyProxy proxy = provider.getWikittyProxy();
        return proxy.restore(beanClass, id);
    }

    public static Class<? extends EmailContentUI> getUIClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())){
                return constant.getUIClass();
            }
        }
        return null;
    }

    public String decorate(Session currentSession, BusinessEntity bean) {
        String result = "";
        switch(this) {
//            case CLIENT:
//                Client client = cast(Client.class, bean);
//                result = client.getName() + " - " + EmailDataHelper.getNbFormToSend(currentSession, client);
//                break;
            case GROUP:
                Group group = cast(Group.class, bean);
                result = group.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, group) + ")";
                break;
            case USER:
                User user = cast(User.class, bean);
                Client client = VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                result = client.getName() + " - " + user.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, user)+ ")";
                break;
            case FORM:
                Form form = cast(Form.class, bean);
                result = form.getObjet();
                break;
            case SESSION:
                // 1 - dd/MM/yyyy - status
                Session session = cast(Session.class, bean);
                StringBuffer buffer = new StringBuffer();
                buffer.append(session.getNum());
                buffer.append(" - ");
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                buffer.append(format.format(session.getSessionDate()));

                VradiConstants.SessionStatus sessionStatus = VradiConstants.SessionStatus.getStatus(session.getStatus());

                if (sessionStatus != null) {
                    buffer.append(" - ");

                    buffer.append(sessionStatus.getDescription());
                } else {
                    log.warn("Cant find status for num : " + session.getStatus());
                }
                result = buffer.toString();

                break;
        }
        return result;
    }

    protected <B extends BusinessEntity> B cast(Class<B> toCast, BusinessEntity bean) {
        return (B) bean;
    }
}
