/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FormViewUI extends com.jurismarches.vradi.ui.email.EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_SESSION = "session";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GROUPS_FORM_BEAN = "groupsForm.bean";
    public static final String BINDING_GROUPS_FORM_SESSION = "groupsForm.session";
    public static final String BINDING_USERS_FORM_BEAN = "usersForm.bean";
    public static final String BINDING_USERS_FORM_SESSION = "usersForm.session";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdm9iJHT6CI0wCBgWwBAroHKBBSoCggEUiBwQmKMINe75VvOY+lt295JIC8RP4CdDTINFRIQpqChrEX0CIghYxe+dPuGCLuFj7dua9eTN+c6+/QUoKONUkQWAI31XMocbKjfX1u2aT1tVNKuuCceUJiD6JJCRrMG517qWCM7WKhpda8NKS53DPpW4Per4CWam2bSoblCoFJ/oRdSlL1U54PuC+aLN2RMWxvvzxPfnCev4qCRBwVDeGrcwMQnU7GalAklkKclhpk5Rs4m6gDMHcDdR7QN8t2UTKO8ShT+EZjFYgzYlAMgWnh2855AjxAVcwUbzlEGYvea7C9LXlOQWzdc8xmr5g0iGi3qDS2BTEYobPDKpzjbInnIeMbq0tcx4ypRWMSiolQxY4uwsc6Zli+FiNMrvYEZMSBBYHAXXdnorFB8S0KQqe6hux3MKBGWFMZ2Y6gLHiSoWY1EZETg8zaKVGtzop18nNbgjP51JXVDA3aCD3fCq2V8kTKqKx9HO1617Uz0f7YxlfUhGW0RfHWkEBx/taQj8aXT92DZOoQUr4eI0zqP1t4fsYisw79Yd5NWEY/ZWf/Pzu69tyr2OPxKb2LBw6iQuPU6H/FQWHIrv6itmlVcLna5CR1MZtDbexECOs2gqjOKx3WMMNDTduE9lAitTol/cf8o8/7YNkGbK2R6wy0fnLkFENgVPwbCvg1xdDRfu3xvCc0NrQSooGuA65BebazKUzROH+mL6i1wIcQyFmDB0tZubjz8nqm8X2KBIobXrX9O44Uo8gHVUL17e1mbHrOs4l9S2vu4FxO5nQ33neMnoxPM/F9hqtzcEFiygyYzLXQjdjnxpwIWxA/zJCvukh+FJ1m+zs6PDl/ydpvwf2RKOvZ/VxPp6hMBTDpX9oODkUw5U9M1wdwPAblHWVEvAGAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.FormViewUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.Form bean;
    protected com.jurismarches.vradi.ui.email.QueryMakerViewUI< Group > groupsForm;
    protected com.jurismarches.vradi.entities.Session session;
    protected com.jurismarches.vradi.ui.email.QueryMakerViewUI< User > usersForm;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FormViewUI $EmailContentUI0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void openUI(VradiTreeNode node) {
        // Get datas
        getHandler().displayForm(this, node);
        Form formSelected = getContextValue(Form.class);
        setBean(formSelected);
    
        session = getHelper().getSessionToDisplay(node);
        updateSession(session);
    }
    
    public void updateSession(Session currentSession){
        setSession(currentSession);
    
        groupsForm.setSession(currentSession);
        usersForm.setSession(currentSession);
    
        java.util.List<User> userSending = VradiHelper.getUsersSendingConcernedBy(session, bean);
        java.util.List<User> allUsers = getAdminHandler().getAllUsers();
        allUsers.removeAll(userSending);
        usersForm.init(true, allUsers, userSending);
    
        java.util.List<Group> groupSending = VradiHelper.getGroupsSendingConcernedBy(session, bean);
        java.util.List<Group> allGroups = getAdminHandler().getAllGroups();
        allGroups.removeAll(groupSending);
        groupsForm.init(true, allGroups, groupSending);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FormViewUI() {
        super();
        $initialize();
    }

    public FormViewUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.Form getBean() {
        return bean;
    }

    public com.jurismarches.vradi.ui.email.QueryMakerViewUI< Group > getGroupsForm() {
        return groupsForm;
    }

    public com.jurismarches.vradi.entities.Session getSession() {
        return session;
    }

    public com.jurismarches.vradi.ui.email.QueryMakerViewUI< User > getUsersForm() {
        return usersForm;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.session;
        this.session = newValue;
        firePropertyChange(PROPERTY_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createGroupsForm() {
        $objectMap.put("groupsForm", groupsForm = new com.jurismarches.vradi.ui.email.QueryMakerViewUI< Group >(this));
        
        groupsForm.setName("groupsForm");
    }

    protected void createSession() {
        $objectMap.put("session", session = null);
    }

    protected void createUsersForm() {
        $objectMap.put("usersForm", usersForm = new com.jurismarches.vradi.ui.email.QueryMakerViewUI< User >(this));
        
        usersForm.setName("usersForm");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $EmailContentUI0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(groupsForm, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(usersForm, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        groupsForm.setClazz(Group.class);
        usersForm.setClazz(User.class);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$EmailContentUI0", this);
        createSession();
        createBean();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.formGroupTitle"));
        createGroupsForm();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.email.formUserTitle"));
        createUsersForm();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUPS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                groupsForm.setSession(getSession());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                usersForm.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USERS_FORM_SESSION, true ,"session") {
        
            @Override
            public void processDataBinding() {
                usersForm.setSession(getSession());
            }
        });
    }

}