/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.loadors;

import java.util.Collections;
import java.util.List;

import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;

/**
 * @author letellier
 */
public class GroupsNodeLoadors extends AbstractVradiNodeLoadors<Group> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1199890344440487950L;

    public GroupsNodeLoadors() {
        super(Group.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Return all groups
        VradiDataService dataService = getDataService(dataProvider);

        List<Group> groups = dataService.findAllGroups();
        Collections.sort(groups, VradiComparators.GROUP_COMPARATOR);

        return extractIds(groups);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {

        // Create groups static nodes
        VradiTreeNode groupNode = createVradiNode(id);

        // Create users category node
        VradiTreeNode usersCategoryNode = new VradiTreeNode(
                String.class,
                AdminBeanConstant.USER.getCategoryName(),
                null,
                NavHelper.getChildLoador(GroupUsersNodeLoadors.class)
        );

        // Add users nodes to groups node
        groupNode.add(usersCategoryNode);

        return groupNode;
    }
}

