/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.*;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.loadors.GroupsNodeLoadors;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

import javax.swing.*;

/**
 * @author letellier
 */
public class GroupNavigationTreeHelper extends AdminNavigationTreeHelper {

    /** Logger. */
    static private final Log log = LogFactory.getLog(GroupNavigationTreeHelper.class);

    public GroupNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.GROUP.getCategoryName(),
                null,
                new GroupsNodeLoadors()
        );
    }

    /*
     * @see org.nuiton.wikitty.WikittyServiceListener#putWikitty(org.nuiton.wikitty.WikittyServiceEvent)
     */
    @Override
    public void putWikitty(final String wikittyId, Set<String> wikittyExtensions) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put event : " + wikittyId);
        }
        if (wikittyExtensions.contains(Group.EXT_GROUP)) {

            SwingUtilities.invokeLater(new Thread() {

                @Override
                public void run() {
                    VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);
                    // cas modification
                    if (existingNode != null) {

                        // Refresh
                        refresh(existingNode);

                        // Add missing users
                        Group group = VradiService.getWikittyProxy().restore(Group.class, wikittyId);
                        Set<String> userIds = group.getUser();
                        if (userIds != null) {
                            for (String userId : userIds) {
                                VradiTreeNode userNode = findNode(existingNode, userId);
                                if (userNode == null) {
                                    VradiTreeNode userCategory = findNode(existingNode, AdminBeanConstant.USER.getCategoryName());
                                    userNode = new VradiTreeNode(User.class, userId, null, null);
                                    insertNode(userCategory, userNode);
                                }
                            }
                        }
                    }

                    // cas creation
                    else {
                        createGroupNode(wikittyId, false);
                    }
                }
            });
        }
    }
}
