/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.services;

import java.util.Properties;

import org.nuiton.util.ListenerSet;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyServiceNotifier;

/**
 * Modifié rapidement pour concurrent modification exception.
 */
public class VradiServiceNotifier extends WikittyServiceNotifier {

    /**
     * Default constructor.
     * 
     * @param ws delegate service
     */
    public VradiServiceNotifier(WikittyService ws) {
        super(ws, null);
    }

    /**
     * Constructor with configuration.
     * 
     * @param ws delegate service
     * @param props properties (can be null)
     */
    public VradiServiceNotifier(WikittyService ws, Properties props) {
        super(ws, props);
    }

    /**
     * Fire event to all registred listener.
     * 
     * Take care about {@link WikittyServiceEvent#isRemote()} for fire.
     *
     * @param event event to fire
     */
    protected void firePutWikitty(final WikittyServiceEvent event) {
        // ajout d'un thread, car si les listener doit
        // ouvrir une transaction WikittyTransaction
        // alors que celui qui lance l'event en a une ouverte
        // cela cause une exception JTA
        Thread eventThread = new Thread("wikitty-event-thread") {
            @Override
            public void run() {
                ListenerSet<WikittyServiceListener> lAll = new ListenerSet<WikittyServiceListener>();
                lAll.addAll(allWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lRemote = new ListenerSet<WikittyServiceListener>();
                lRemote.addAll(remoteWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lLocal = new ListenerSet<WikittyServiceListener>();
                lLocal.addAll(localWikittyServiceListeners);
                for (WikittyServiceListener l : lAll) {
                    l.putWikitty(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : lRemote) {
                        l.putWikitty(event);
                    }
                }
                else {
                    for (WikittyServiceListener l : lLocal) {
                        l.putWikitty(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    /**
     * Fire event to all registred listener.
     * 
     * Take care about {@link WikittyServiceEvent#isRemote()} for fire.
     *
     * @param event event to fire
     */
    protected void fireRemoveWikitty(final WikittyServiceEvent event) {
        // ajout d'un thread, car si les listener doit
        // ouvrir une transaction WikittyTransaction
        // alors que celui qui lance l'event en a une ouverte
        // cela cause une exception JTA
        Thread eventThread = new Thread("wikitty-event-thread") {
            @Override
            public void run() {
                ListenerSet<WikittyServiceListener> lAll = new ListenerSet<WikittyServiceListener>();
                lAll.addAll(allWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lRemote = new ListenerSet<WikittyServiceListener>();
                lRemote.addAll(remoteWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lLocal = new ListenerSet<WikittyServiceListener>();
                lLocal.addAll(localWikittyServiceListeners);
                for (WikittyServiceListener l : lAll) {
                    l.removeWikitty(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : lRemote) {
                        l.removeWikitty(event);
                    }
                }
                else {
                    for (WikittyServiceListener l : lLocal) {
                        l.removeWikitty(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    /**
     * Fire event to all registred listener.
     * 
     * Take care about {@link WikittyServiceEvent#isRemote()} for fire.
     *
     * @param event event to fire
     */
    protected void fireClearWikitty(final WikittyServiceEvent event) {
        // ajout d'un thread, car si les listener doit
        // ouvrir une transaction WikittyTransaction
        // alors que celui qui lance l'event en a une ouverte
        // cela cause une exception JTA
        Thread eventThread = new Thread("wikitty-event-thread") {
            @Override
            public void run() {
                ListenerSet<WikittyServiceListener> lAll = new ListenerSet<WikittyServiceListener>();
                lAll.addAll(allWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lRemote = new ListenerSet<WikittyServiceListener>();
                lRemote.addAll(remoteWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lLocal = new ListenerSet<WikittyServiceListener>();
                lLocal.addAll(localWikittyServiceListeners);
                for (WikittyServiceListener l : lAll) {
                    l.clearWikitty(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : lRemote) {
                        l.clearWikitty(event);
                    }
                }
                else {
                    for (WikittyServiceListener l : lLocal) {
                        l.clearWikitty(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    /**
     * Fire event to all registred listener.
     * 
     * Take care about {@link WikittyServiceEvent#isRemote()} for fire.
     *
     * @param event event to fire
     */
    protected void firePutExtension(final WikittyServiceEvent event) {
     // ajout d'un thread, car si les listener doit
        // ouvrir une transaction WikittyTransaction
        // alors que celui qui lance l'event en a une ouverte
        // cela cause une exception JTA
        Thread eventThread = new Thread("wikitty-event-thread") {
            @Override
            public void run() {
                ListenerSet<WikittyServiceListener> lAll = new ListenerSet<WikittyServiceListener>();
                lAll.addAll(allWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lRemote = new ListenerSet<WikittyServiceListener>();
                lRemote.addAll(remoteWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lLocal = new ListenerSet<WikittyServiceListener>();
                lLocal.addAll(localWikittyServiceListeners);
                for (WikittyServiceListener l : lAll) {
                    l.putExtension(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : lRemote) {
                        l.putExtension(event);
                    }
                }
                else {
                    for (WikittyServiceListener l : lLocal) {
                        l.putExtension(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    /**
     * Fire event to all registred listener.
     * 
     * Take care about {@link WikittyServiceEvent#isRemote()} for fire.
     *
     * @param event event to fire
     */
    protected void fireRemoveExtension(final WikittyServiceEvent event) {
     // ajout d'un thread, car si les listener doit
        // ouvrir une transaction WikittyTransaction
        // alors que celui qui lance l'event en a une ouverte
        // cela cause une exception JTA
        Thread eventThread = new Thread("wikitty-event-thread") {
            @Override
            public void run() {
                ListenerSet<WikittyServiceListener> lAll = new ListenerSet<WikittyServiceListener>();
                lAll.addAll(allWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lRemote = new ListenerSet<WikittyServiceListener>();
                lRemote.addAll(remoteWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lLocal = new ListenerSet<WikittyServiceListener>();
                lLocal.addAll(localWikittyServiceListeners);
                for (WikittyServiceListener l : lAll) {
                    l.removeExtension(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : lRemote) {
                        l.removeExtension(event);
                    }
                }
                else {
                    for (WikittyServiceListener l : lLocal) {
                        l.removeExtension(event);
                    }
                }
            }
        };
        eventThread.start();
    }

    /**
     * Fire event to all registred listener.
     * 
     * Take care about {@link WikittyServiceEvent#isRemote()} for fire.
     *
     * @param event event to fire
     */
    protected void fireClearExtension(final WikittyServiceEvent event) {
        // ajout d'un thread, car si les listener doit
        // ouvrir une transaction WikittyTransaction
        // alors que celui qui lance l'event en a une ouverte
        // cela cause une exception JTA
        Thread eventThread = new Thread("wikitty-event-thread") {
            @Override
            public void run() {
                ListenerSet<WikittyServiceListener> lAll = new ListenerSet<WikittyServiceListener>();
                lAll.addAll(allWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lRemote = new ListenerSet<WikittyServiceListener>();
                lRemote.addAll(remoteWikittyServiceListeners);
                ListenerSet<WikittyServiceListener> lLocal = new ListenerSet<WikittyServiceListener>();
                lLocal.addAll(localWikittyServiceListeners);
                for (WikittyServiceListener l : lAll) {
                    l.clearExtension(event);
                }
                if (event.isRemote()) {
                    for (WikittyServiceListener l : lRemote) {
                        l.clearExtension(event);
                    }
                }
                else {
                    for (WikittyServiceListener l : lLocal) {
                        l.clearExtension(event);
                    }
                }
            }
        };
        eventThread.start();
    }
}
