/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class ThesaurusDataHelper {
    private static final Log log = LogFactory.getLog(ThesaurusDataHelper.class);

    public static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static Thesaurus restoreThesaurus(String thesaurusId) {
        return (Thesaurus)ThesaurusDataHelper.getProxy().restore(Thesaurus.class, thesaurusId);
    }

    public static List<Thesaurus> restoreThesaurus(List<String> thesaurusIds) {
        return ThesaurusDataHelper.getProxy().restore(Thesaurus.class, thesaurusIds);
    }

    public static List<Thesaurus> restoreThesaurus(Set<String> thesaurusIds) {
        return ThesaurusDataHelper.restoreThesaurus(new ArrayList<String>(thesaurusIds));
    }

    public static RootThesaurus restoreRootThesaurus(String rootThesaurusId) {
        return (RootThesaurus)ThesaurusDataHelper.getProxy().restore(RootThesaurus.class, rootThesaurusId);
    }

    public static List<RootThesaurus> restoreRootThesaurus(List<String> rootThesaurusIds) {
        return ThesaurusDataHelper.getProxy().restore(RootThesaurus.class, rootThesaurusIds);
    }

    public static String getNamePath(Thesaurus thesaurus, String pathSeparator) {
        if (thesaurus == null) {
            return "";
        }
        String parentId = thesaurus.getParent();
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            return ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus()).getName() + pathSeparator + ThesaurusDataHelper.concateOrderName(thesaurus);
        }
        Thesaurus parentThesaurus = ThesaurusDataHelper.restoreThesaurus(parentId);
        return ThesaurusDataHelper.getNamePath(parentThesaurus, pathSeparator) + pathSeparator + ThesaurusDataHelper.concateOrderName(thesaurus);
    }

    public static String concateOrderName(Thesaurus thesaurus) {
        String result = thesaurus.getName();
        int order = thesaurus.getOrder();
        if (order != 0) {
            result = order + " - " + result;
        }
        return result;
    }

    public static String getTagsAsString(Thesaurus thesaurus) {
        if (thesaurus == null) {
            return "";
        }
        Set tags = thesaurus.getTags();
        StringBuilder tagAsString = new StringBuilder();
        if (tags != null) {
            for (String tag : tags) {
                tagAsString.append(tag);
                tagAsString.append(", ");
            }
            int length = tagAsString.length();
            if (length > 0) {
                tagAsString.delete(length - 2, length);
            }
        }
        return tagAsString.toString();
    }

    public static void setTagsAsString(Thesaurus thesaurus, String tagsAsString) {
        if (tagsAsString != null) {
            thesaurus.clearTags();
            for (String tag : tagsAsString.split(",")) {
                thesaurus.addTags(tag.trim());
            }
        }
    }

    public static int getNbFormsForThesaurus(Thesaurus thesaurus) {
        Map.Entry entry = ThesaurusDataHelper.getProxy().restoreNode(Thesaurus.class, thesaurus.getWikittyId(), null);
        if (entry == null) {
            return 0;
        }
        return (Integer)entry.getValue();
    }

    protected static List<String> getStringAsList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(s);
        return result;
    }

    public static List<Thesaurus> getChildrenOfThesaurus(String thesaurusId) {
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Thesaurus");
        query.eq("TreeNode.parent", thesaurusId);
        Criteria criteria = query.criteria();
        PagedResult nodes = ThesaurusDataHelper.getProxy().findAllByCriteria(Thesaurus.class, criteria);
        ArrayList<Thesaurus> all = new ArrayList<Thesaurus>(nodes.getAll());
        if (log.isDebugEnabled()) {
            Thesaurus thesaurus = ThesaurusDataHelper.restoreThesaurus(thesaurusId);
            log.debug((Object)("[Get children of thesaurus : " + thesaurus.getName() + "] Found " + all.size() + " children"));
            for (Thesaurus child : all) {
                log.debug((Object)("[Get children of thesaurus : " + thesaurus.getName() + "] Found " + child.getName()));
            }
        }
        return all;
    }

    public static List<Thesaurus> getChildrenOfRootThesaurus(String rootThesaurusId) {
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Thesaurus");
        query.eq("TreeNode.parent", rootThesaurusId);
        Criteria criteria = query.criteria();
        PagedResult nodes = ThesaurusDataHelper.getProxy().findAllByCriteria(Thesaurus.class, criteria);
        ArrayList<Thesaurus> all = new ArrayList<Thesaurus>(nodes.getAll());
        if (log.isDebugEnabled()) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(rootThesaurusId);
            log.debug((Object)("[Get children of root thesaurus : " + rootThesaurus.getName() + "] Found " + all.size() + " children"));
            for (Thesaurus child : all) {
                log.debug((Object)("[Get children of root thesaurus : " + rootThesaurus.getName() + "] Found " + child.getName()));
            }
        }
        return all;
    }

    public static List<Thesaurus> getAllThesaurus() {
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        PagedResult thesaurusResult = ThesaurusDataHelper.getProxy().findAllByCriteria(Thesaurus.class, criteria);
        ArrayList<Thesaurus> all = new ArrayList<Thesaurus>(thesaurusResult.getAll());
        return all;
    }

    public static List<RootThesaurus> getAllRootThesaurus() {
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "RootThesaurus").criteria();
        PagedResult rootThesaurusResult = ThesaurusDataHelper.getProxy().findAllByCriteria(RootThesaurus.class, criteria);
        ArrayList<RootThesaurus> all = new ArrayList<RootThesaurus>(rootThesaurusResult.getAll());
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Get all root thesaurus] Found " + all.size() + " children"));
            for (RootThesaurus child : all) {
                log.debug((Object)("[Get all root thesaurus] Found " + child.getName()));
            }
        }
        return all;
    }

    public static boolean checkRootNameExist(String name) {
        List<RootThesaurus> rootThesaurusList = ThesaurusDataHelper.getAllRootThesaurus();
        for (RootThesaurus rootThesaurus : rootThesaurusList) {
            if (!name.equalsIgnoreCase(rootThesaurus.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRootNameExist(RootThesaurus rootThesaurusConcerned) {
        String name = rootThesaurusConcerned.getName();
        String id = rootThesaurusConcerned.getWikittyId();
        List<RootThesaurus> rootThesaurusList = ThesaurusDataHelper.getAllRootThesaurus();
        for (RootThesaurus rootThesaurus : rootThesaurusList) {
            if (id.equals(rootThesaurus.getWikittyId()) || !name.equalsIgnoreCase(rootThesaurus.getName())) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkNameExist(Thesaurus thesaurus, String name) {
        if (thesaurus.getName().equalsIgnoreCase(name)) {
            return true;
        }
        List<Thesaurus> children = ThesaurusDataHelper.getChildrenOfThesaurus(thesaurus.getWikittyId());
        for (Thesaurus child : children) {
            boolean result = ThesaurusDataHelper.checkNameExist(child, name);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public static boolean checkNameExist(RootThesaurus rootThesaurus, String name) {
        List<Thesaurus> children = ThesaurusDataHelper.getChildrenOfRootThesaurus(rootThesaurus.getWikittyId());
        for (Thesaurus child : children) {
            boolean result = ThesaurusDataHelper.checkNameExist(child, name);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public static boolean checkNameExist(RootThesaurus rootThesaurus, Thesaurus thesaurusConcerned) {
        String name = thesaurusConcerned.getName();
        String id = thesaurusConcerned.getWikittyId();
        List<Thesaurus> children = ThesaurusDataHelper.getChildrenOfRootThesaurus(rootThesaurus.getWikittyId());
        for (Thesaurus child : children) {
            boolean result = ThesaurusDataHelper.checkNameExist(child, name, id);
            if (!result) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkNameExist(Thesaurus thesaurus, String name, String id) {
        if (!id.equals(thesaurus.getWikittyId()) && thesaurus.getName().equalsIgnoreCase(name)) {
            return true;
        }
        List<Thesaurus> children = ThesaurusDataHelper.getChildrenOfThesaurus(thesaurus.getWikittyId());
        for (Thesaurus child : children) {
            boolean result = ThesaurusDataHelper.checkNameExist(child, name, id);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public static String getRecursifName(Thesaurus thesaurus) {
        return ThesaurusDataHelper.getRecursifName(thesaurus, ThesaurusDataHelper.concateOrderName(thesaurus));
    }

    protected static String getRecursifName(Thesaurus thesaurus, String name) {
        StringBuilder builder = new StringBuilder(name);
        List<Thesaurus> children = ThesaurusDataHelper.getChildrenOfThesaurus(thesaurus.getWikittyId());
        for (Thesaurus child : children) {
            builder.append(", ");
            builder.append(ThesaurusDataHelper.getRecursifName(child));
        }
        return builder.toString();
    }

    public static String getParentPath(Thesaurus thesaurus, String pathSeparator) {
        if (thesaurus == null) {
            return pathSeparator;
        }
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus());
            return rootThesaurus.getName();
        }
        String parentId = thesaurus.getParent();
        Thesaurus parentThesaurus = ThesaurusDataHelper.restoreThesaurus(parentId);
        return ThesaurusDataHelper.getParentPath(parentThesaurus, pathSeparator) + pathSeparator + ThesaurusDataHelper.concateOrderName(parentThesaurus);
    }

    public static int getDepth(Thesaurus thesaurus) {
        if (thesaurus == null) {
            return 0;
        }
        if (ThesaurusDataHelper.isFirstChild(thesaurus)) {
            return 2;
        }
        String parentId = thesaurus.getParent();
        Thesaurus parent = ThesaurusDataHelper.restoreThesaurus(parentId);
        return 1 + ThesaurusDataHelper.getDepth(parent);
    }

    public static List<String> getChildrenRecursif(Thesaurus thesaurus) {
        return ThesaurusDataHelper.getChildrenRecursif(thesaurus, true);
    }

    protected static List<String> getChildrenRecursif(Thesaurus thesaurus, boolean putFirst) {
        ArrayList<String> result = new ArrayList<String>();
        if (putFirst) {
            result.add(thesaurus.getWikittyId());
        }
        for (Thesaurus child : ThesaurusDataHelper.getChildrenOfThesaurus(thesaurus.getWikittyId())) {
            result.addAll(ThesaurusDataHelper.getChildrenRecursif(child, false));
        }
        return result;
    }

    public static List<String> getChildrenRecursif(RootThesaurus thesaurus) {
        ArrayList<String> result = new ArrayList<String>();
        for (Thesaurus child : ThesaurusDataHelper.getChildrenOfRootThesaurus(thesaurus.getWikittyId())) {
            result.addAll(ThesaurusDataHelper.getChildrenRecursif(child));
        }
        return result;
    }

    public static boolean isFirstChild(Thesaurus thesaurus) {
        String rootThesaurus = thesaurus.getRootThesaurus();
        String parent = thesaurus.getParent();
        if (parent == null) {
            return false;
        }
        return parent.equals(rootThesaurus);
    }

    public static String getRequestName(Thesaurus thesaurus) {
        String rootId = thesaurus.getRootThesaurus();
        RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(rootId);
        return rootThesaurus.getName() + ":" + thesaurus.getName();
    }
}

