package com.jurismarches.vradi.ui.tree;

import jaxx.runtime.swing.nav.NavDataProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;

import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiService;

/**
 * Provider de données pour les noeuds des arbres.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class VradiDataProvider implements NavDataProvider {

    /** Logger */
    static private final Log log = LogFactory.getLog(VradiDataProvider.class);

    /** Wikitty proxy. */
    protected WikittyProxy proxy;

    /** Vradi data service. */
    protected VradiDataService dataService;

    public VradiDataProvider() {
        this.proxy = VradiService.getWikittyProxy();
        this.dataService = VradiService.getVradiDataService();
    }

    /**
     * Get wikitty proxy.
     * 
     * @return
     */
    public WikittyProxy getWikittyProxy() {
        return proxy;
    }

    /**
     * Get vradi data service.
     * 
     * @return
     */
    public VradiDataService getVradiDataService() {
        return dataService;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}
