/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.email.renderers;


import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import org.nuiton.wikitty.WikittyProxy;

import javax.swing.*;
import java.awt.*;

/**
 * User: letellier
 */
public class SendingRenderer extends DefaultListCellRenderer{

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        WikittyProxy proxy = VradiService.getWikittyProxy();

        Sending sending = (Sending)value;

        String text = "";
        String userId = sending.getUser();
        String groupId = sending.getGroup();
        if (userId != null){
            User user = proxy.restore(User.class, userId);
            Client client = proxy.restore(Client.class, user.getClient());
            text = client.getName() + " - " + user.getName();
        } else if (groupId != null){
            Group group = proxy.restore(Group.class, groupId);
            text =  group.getName();
        }

        return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
    }
}
