package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailGroupNodeLoadors extends AbstractEmailNodeLoador<Group> {

    public EmailGroupNodeLoadors () {
        super(Group.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Get sending of session
        List<Sending> sendings = getSendingList(dataProvider, parentId);

        // Extract group ids
        List<String> groupIds = new ArrayList<String>();
        for (Sending sending : sendings) {
            groupIds.add(sending.getGroup());
        }

        // Sort
        List<Group> groupSorted = VradiService.getWikittyProxy().restore(Group.class, groupIds);
        Collections.sort(groupSorted,  VradiComparators.GROUP_COMPARATOR);

        // Return groups
        return extractIds(groupSorted);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id, NavHelper.getChildLoador(EmailGroupUsersNodeLoadors.class));
    }
}
