/* *##%
 * Copyright (C) 2010 Code Lutin, Chatellier Eric
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.FormViewUI;
import com.jurismarches.vradi.ui.email.SessionsListUI;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;

import java.text.SimpleDateFormat;

/**
 *
 * @author sletellier
 * @version $Revision: 1155 $
 *
 * Last update : $Date: 2010-07-16 19:57:44 +0200 (ven. 16 juil. 2010) $
 * By : $Author: sletellier $
 */
public enum EmailBeanConstant {

    // Client
//    CLIENT(Client.class, SessionsListUI.class),
    // Group
    GROUP(Group.class, SessionsListUI.class),
    // User
    USER(User.class, SessionsListUI.class),
    // Form
    FORM(Form.class, FormViewUI.class),
    //Session$
    SESSION(Session.class, SessionsListUI.class);

    protected Class<? extends BusinessEntity> beanClass;

    protected Class<? extends EmailContentUI> uiClass;

    private EmailBeanConstant(Class<? extends BusinessEntity> beanClass, Class<? extends EmailContentUI> uiClass) {
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public Class<? extends BusinessEntity> getBeanClass() {
        return beanClass;
    }

    public Class<? extends EmailContentUI> getUIClass() {
        return uiClass;
    }

    public static EmailBeanConstant getConstantByBeanClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())){
                return constant;
            }
        }
        return null;
    }

    public BusinessEntity getBean(VradiDataProvider provider, String id) {
        WikittyProxy proxy = provider.getWikittyProxy();
        return proxy.restore(beanClass, id);
    }

    public static Class<? extends EmailContentUI> getUIClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : values()) {
            if (beanClass.equals(constant.getBeanClass())){
                return constant.getUIClass();
            }
        }
        return null;
    }

    public String decorate(Session currentSession, BusinessEntity bean) {
        String result = "";
        switch(this) {
//            case CLIENT:
//                Client client = cast(Client.class, bean);
//                result = client.getName() + " - " + EmailDataHelper.getNbFormToSend(currentSession, client);
//                break;
            case GROUP:
                Group group = cast(Group.class, bean);
                result = group.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, group) + ")";
                break;
            case USER:
                User user = cast(User.class, bean);
                Client client = VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                result = client.getName() + " - " + user.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, user)+ ")";
                break;
            case FORM:
                Form form = cast(Form.class, bean);
                result = form.getObjet();
                break;
            case SESSION:
                // 1 - dd/MM/yyyy (nbForms) - status
                Session session = cast(Session.class, bean);
                StringBuffer buffer = new StringBuffer();
                buffer.append(session.getNum());
                buffer.append(" - ");
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                buffer.append(format.format(session.getSessionDate()));
                buffer.append(" (");
                buffer.append(EmailDataHelper.getNbFormToSend(session));
                buffer.append(")");

                buffer.append(" - ");
                buffer.append(VradiConstants.SessionStatus.getStatus(session.getStatus()).getDescription());

                result = buffer.toString();

                break;
        }
        return result;
    }

    protected <B extends BusinessEntity> B cast(Class<B> toCast, BusinessEntity bean) {
        return (B) bean;
    }
}
