package com.jurismarches.vradi.ui.admin.popups;

import com.jurismarches.vradi.VradiConstants.XmlStreamConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.popups.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Calendar;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class XmlStreamConfigUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INTERVAL_MODEL = "interval.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.popups.XmlStreamConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton cancel;
    protected javax.swing.JPanel daysPanel;
    protected javax.swing.JComboBox hourDays;
    protected javax.swing.JPanel hoursPanel;
    protected javax.swing.JComboBox interval;
    protected javax.swing.JComboBox minuteDays;
    protected javax.swing.JComboBox minuteHours;
    protected javax.swing.JButton save;
    protected javax.swing.JComboBox unit;
    protected XmlStreamConfigUI xmlStreamConfigUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private jaxx.runtime.swing.Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ComboBoxModel minutesModel;
    protected ComboBoxModel hoursModel;
    protected ComboBoxModel daysModel;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        VradiStorageService storageService = VradiService.getVradiStorageService();
        String[] config = storageService.getXmlStreamConfig();
        String intervalUnit = config[0];
        String intervalValue = config[1];
        String hour = config[2];
        String minute = config[3];
        if(intervalUnit != null) {
            unit.setSelectedItem(intervalUnit);
            if(intervalValue != null) {
                interval.setSelectedItem(Integer.valueOf(intervalValue));
            }
            if(hour != null) {
                hourDays.setSelectedItem(Integer.valueOf(hour));
                if(minute != null) {
                    this.minuteDays.setSelectedItem(Integer.valueOf(minute));
                }
            } else {
                this.minuteHours.setSelectedItem(Integer.valueOf(minute));
            }
        }
    }
    
    protected void updateIntervalModel() {
        if(unit.getSelectedItem().equals(XmlStreamConfig.MINUTES.getValue())) {
            interval.setModel(minutesModel);
            daysPanel.setVisible(false);
            hoursPanel.setVisible(false);
        } else if(unit.getSelectedItem().equals(XmlStreamConfig.HOURS.getValue())) {
            interval.setModel(hoursModel);
            if(interval.getSelectedItem() == null) {
                interval.setSelectedItem(1);
            }
            hoursPanel.setVisible(true);
            daysPanel.setVisible(false);
        } else if(unit.getSelectedItem().equals(XmlStreamConfig.DAYS.getValue())) {
            interval.setModel(daysModel);
            hoursPanel.setVisible(false);
            daysPanel.setVisible(true);
        }
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public XmlStreamConfigUI() {
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(java.awt.event.ActionEvent event) {
        this.dispose();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        getHandler().saveXmlStreamConfig(this);                                             this.dispose();
    }

    public void doActionPerformed__on__unit(java.awt.event.ActionEvent event) {
        updateIntervalModel();
    }

    public void doWindowClosing__on__xmlStreamConfigUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JPanel getDaysPanel() {
        return daysPanel;
    }

    public javax.swing.JComboBox getHourDays() {
        return hourDays;
    }

    public javax.swing.JPanel getHoursPanel() {
        return hoursPanel;
    }

    public javax.swing.JComboBox getInterval() {
        return interval;
    }

    public javax.swing.JComboBox getMinuteDays() {
        return minuteDays;
    }

    public javax.swing.JComboBox getMinuteHours() {
        return minuteHours;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.JComboBox getUnit() {
        return unit;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDaysPanel() {
        if (!allComponentsCreated) {
            return;
        }
        daysPanel.add($JLabel3);
        daysPanel.add(hourDays);
        daysPanel.add($JLabel4);
        daysPanel.add(minuteDays);
    }

    protected void addChildrenToHoursPanel() {
        if (!allComponentsCreated) {
            return;
        }
        hoursPanel.add($JLabel2);
        hoursPanel.add(minuteHours);
    }

    protected void addChildrenToXmlStreamConfigUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.WEST);
        add($Table1, BorderLayout.SOUTH);
    }

    protected void create$JLabel0() {
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.config.title"));
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont((float) 20));
        }
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new javax.swing.JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createDaysPanel() {
        $objectMap.put("daysPanel", daysPanel = new javax.swing.JPanel());
        
        daysPanel.setName("daysPanel");
        daysPanel.setAlignmentX(0.5F);
        daysPanel.setAlignmentY(0.0F);
    }

    protected void createHourDays() {
        $objectMap.put("hourDays", hourDays = new javax.swing.JComboBox());
        
        hourDays.setName("hourDays");
    }

    protected void createHoursPanel() {
        $objectMap.put("hoursPanel", hoursPanel = new javax.swing.JPanel());
        
        hoursPanel.setName("hoursPanel");
        hoursPanel.setAlignmentX(0.5F);
        hoursPanel.setAlignmentY(0.0F);
    }

    protected void createInterval() {
        $objectMap.put("interval", interval = new javax.swing.JComboBox());
        
        interval.setName("interval");
    }

    protected void createMinuteDays() {
        $objectMap.put("minuteDays", minuteDays = new javax.swing.JComboBox());
        
        minuteDays.setName("minuteDays");
    }

    protected void createMinuteHours() {
        $objectMap.put("minuteHours", minuteHours = new javax.swing.JComboBox());
        
        minuteHours.setName("minuteHours");
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createUnit() {
        $objectMap.put("unit", unit = new javax.swing.JComboBox());
        
        unit.setName("unit");
        unit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__unit"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToXmlStreamConfigUI();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel1);
        $JPanel0.add(interval);
        $JPanel0.add(unit);
        $JPanel0.add(hoursPanel);
        $JPanel0.add(daysPanel);
        addChildrenToHoursPanel();
        addChildrenToDaysPanel();
        // inline complete setup of $Table1
        $Table1.add(cancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(save, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 20 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        interval.setRenderer(UIHelper.get2DigitsRenderer());
        interval.setSelectedItem(1);
        unit.setModel(new DefaultComboBoxModel(new String[]{                         XmlStreamConfig.MINUTES.getValue(),                         XmlStreamConfig.HOURS.getValue(),                         XmlStreamConfig.DAYS.getValue()}));
        unit.setRenderer(UIHelper.getTranslationRenderer());
        unit.setSelectedItem(XmlStreamConfig.DAYS.getValue());
        minuteHours.setModel(UIHelper.getMinuteModel());
        minuteHours.setRenderer(UIHelper.get2DigitsRenderer());
        minuteHours.setSelectedItem(0);
        hourDays.setModel(UIHelper.getHourModel());
        hourDays.setRenderer(UIHelper.get2DigitsRenderer());
        hourDays.setSelectedItem(0);
        minuteDays.setModel(UIHelper.getMinuteModel());
        minuteDays.setRenderer(UIHelper.get2DigitsRenderer());
        minuteDays.setSelectedItem(0);
        cancel.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("save"));
        $JLabel0.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        $JLabel0.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        xmlStreamConfigUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("xmlStreamConfigUI", this);
        minutesModel = new DefaultComboBoxModel(new Object[]{15, 30, 45});
        hoursModel = UIHelper.getNumberComboBoxModel(1, 24);
        daysModel = UIHelper.getNumberComboBoxModel(1, 31);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        create$JLabel0();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setAlignmentX(0.5F);
        $JPanel0.setAlignmentY(0.0F);
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminXmlStream.config.load"));
        createInterval();
        createUnit();
        createHoursPanel();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminXmlStream.config.label.hours"));
        createMinuteHours();
        createDaysPanel();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminXmlStream.config.label.days"));
        createHourDays();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.common.timeseparator"));
        createMinuteDays();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createCancel();
        createSave();
        // inline creation of xmlStreamConfigUI
        setName("xmlStreamConfigUI");
        xmlStreamConfigUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.adminXmlStream.config.title"));
        xmlStreamConfigUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__xmlStreamConfigUI"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_INTERVAL_MODEL, true ,"daysModel") {
        
            @Override
            public void processDataBinding() {
                interval.setModel(daysModel);
            }
        });
    }

}