package com.jurismarches.vradi.ui.admin.popups;

import java.util.List;
import java.util.Map;

import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;

import com.jurismarches.vradi.entities.Group;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;

import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.TreeTableModel;

import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.ui.admin.query.QueryCellEditor;
import com.jurismarches.vradi.ui.admin.query.QueryCheckCellRenderer;
import com.jurismarches.vradi.ui.admin.query.ThesaurusChangesTreeTableModel;

/**
 * ThesaurusQueryChangesHandler.
 *
 * @author schorlet
 * @version $Revision: 1165 $ $Date: 2010-07-27 12:06:10 +0200 (mar., 27 juil. 2010) $
 * @since 25 mars 2010 15:05:55
 */
public class ThesaurusQueryChangesHandler {

    public ThesaurusQueryChangesUI initUI(JAXXContext rootContext, Map<Group, List<QueryBean>> queries,
            String rootThesaurusBefore, String rootThesaurusAfter,
            String thesaurusBefore, String thesaurusAfter) {
        JAXXInitialContext context = new JAXXInitialContext().add(rootContext).add(this);
        context.add("queries", queries);
        context.add("before", rootThesaurusBefore + ":" + (thesaurusBefore == null ? "" : thesaurusBefore));
        context.add("after", rootThesaurusAfter + ":" + (thesaurusAfter == null ? "*" : thesaurusAfter));
        
        ThesaurusQueryChangesUI thesaurusChangesUI = new ThesaurusQueryChangesUI(context);
        final JXTreeTable resultTreeTable = thesaurusChangesUI.getResultTreeTable();
        resultTreeTable.expandAll();
        
        // editor column
        TableColumn column = resultTreeTable.getColumnModel().getColumn(3);
        column.setCellEditor(new QueryCellEditor(rootContext));
        
        // checkbox column
        column = resultTreeTable.getColumnModel().getColumn(4);
        QueryCheckCellRenderer checkBox = new QueryCheckCellRenderer();
        column.setCellRenderer(checkBox);
        column.setCellEditor(new DefaultCellEditor(checkBox));
        column.setMaxWidth((int)checkBox.getPreferredSize().getWidth());
        
        final Highlighter highlighter = HighlighterFactory.createAlternateStriping(
        HighlighterFactory.NOTEPAD, HighlighterFactory.GENERIC_GRAY);
        resultTreeTable.addHighlighter(highlighter);
        
        return thesaurusChangesUI;
    }

    void close(ThesaurusQueryChangesUI context) {
        context.setVisible(false);
        context.dispose();
    }
     
    public TreeTableModel getResultTreeTableModel(ThesaurusQueryChangesUI context) {
        ThesaurusChangesTreeTableModel treeTableModel = context.getContextValue(ThesaurusChangesTreeTableModel.class);
        if (treeTableModel == null) {
            Map<QueryMaker, List<QueryBean>> queries = context.getContextValue(Map.class, "queries");
            String before = context.getContextValue(String.class, "before");
            String after = context.getContextValue(String.class, "after");
            
            treeTableModel = new ThesaurusChangesTreeTableModel(queries, before, after);
            context.setContextValue(treeTableModel);
        }
        return treeTableModel;
    }
}
