package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestSelectUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_QUERY_DESCRIPTION_TEXT = "queryDescription.text";
    public static final String BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT = "queryDescription.toolTipText";
    public static final String BINDING_QUERY_NAME_TEXT = "queryName.text";
    public static final String BINDING_QUERY_NAME_TOOL_TIP_TEXT = "queryName.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_TOOL_TIP_TEXT = "$JButton0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.beans.QueryBean bean;
    protected javax.swing.JTextArea queryDescription;
    protected javax.swing.JTextField queryName;
    protected RequestSelectUI requestSelectUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    public void confirmDeletion() {
        com.jurismarches.vradi.beans.QueryBean queryBean = getBean();
        if (StringUtils.isBlank(queryBean.getName())
                && StringUtils.isBlank(queryBean.getDescription())
                && StringUtils.isBlank(queryBean.getQuery())) {
            setBean(null);
            
        } else {
            int confirm = JOptionPane.showConfirmDialog(this,
                    _("vradi.admin.confirmDelete", VradiHelper.getEntityName(getBean())),
                    _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);
        
            if (confirm == JOptionPane.YES_OPTION) {
                setBean(null);
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestSelectUI() {
        $initialize();
    }

    public RequestSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().openRequest(this, getBean());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        confirmDeletion();
    }

    public void doKeyReleased__on__queryDescription(java.awt.event.KeyEvent event) {
        setBean(getBean().setDescription(queryDescription.getText()));
    }

    public void doKeyReleased__on__queryName(java.awt.event.KeyEvent event) {
        setBean(getBean().setName(queryName.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.beans.QueryBean getBean() {
        return bean;
    }

    public javax.swing.JTextArea getQueryDescription() {
        return queryDescription;
    }

    public javax.swing.JTextField getQueryName() {
        return queryName;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.beans.QueryBean newValue) {
        com.jurismarches.vradi.beans.QueryBean oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add($JLabel1, new GridBagConstraints(1, 0, 3, 1, 0.7, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add(queryName, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.beans.QueryBean());
    }

    protected void createQueryDescription() {
        $objectMap.put("queryDescription", queryDescription = new javax.swing.JTextArea());
        
        queryDescription.setName("queryDescription");
        queryDescription.setColumns(15);
        queryDescription.setLineWrap(true);
        queryDescription.setWrapStyleWord(true);
        queryDescription.setRows(2);
        queryDescription.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryDescription"));
    }

    protected void createQueryName() {
        $objectMap.put("queryName", queryName = new javax.swing.JTextField());
        
        queryName.setName("queryName");
        queryName.setColumns(15);
        queryName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryName"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(queryDescription);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("requestSelectUI", this);
        createBean();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.requestSelectUI.name"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.requestSelectUI.description"));
        createQueryName();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createQueryDescription();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.edit"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminRequest.remove"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryName.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryDescription.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryDescription, getBean().getDescription());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    $JButton0.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
    }

}