/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.query;

import com.jurismarches.vradi.services.dto.VradiQueryBean;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.AdminRequestUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultJAXXContext;

public class QueryCellEditor
extends AbstractCellEditor
implements TreeCellEditor,
TableCellEditor {
    private static final long serialVersionUID = 1L;
    final JLabel label;
    final JAXXContext parentContext;
    String currentQuery = null;

    public QueryCellEditor(JAXXContext context) {
        this.parentContext = context;
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                QueryCellEditor.this.openRequest();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentQuery;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentQuery = (String)value;
        this.label.setText(this.currentQuery);
        return this.label;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.currentQuery = (String)value;
        this.label.setText(this.currentQuery);
        return this.label;
    }

    public void openRequest() {
        DefaultJAXXContext context = new DefaultJAXXContext();
        context.setContextValue((Object)this.parentContext);
        VradiQueryBean query = new VradiQueryBean();
        query = query.setQuery(this.currentQuery);
        AdminHandler adminHandler = UIHelper.getHandler((JAXXContext)context, AdminHandler.class);
        AdminRequestUI adminRequestUI = adminHandler.createAdminRequestUI((JAXXContext)context, query, null);
        adminRequestUI.addPropertyChangeListener("request", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                QueryCellEditor.this.currentQuery = (String)evt.getNewValue();
            }
        });
        adminRequestUI.setModal(true);
        adminRequestUI.setVisible(true);
        this.fireEditingStopped();
    }
}

