/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.dto.VradiCartographyDTO;
import com.jurismarches.vradi.ui.VradiComparators;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;
import org.sharengo.wikitty.TreeNodeImpl;

public class ThesaurusCartographyModel
extends AbstractTreeTableModel {
    final Map<String, List<TreeNodeImpl>> nodeList = new HashMap<String, List<TreeNodeImpl>>();
    final Map<String, List<Form>> formList = new HashMap<String, List<Form>>();
    final ArrayList<TreeNodeImpl> topLevels = new ArrayList();
    final Map<TreeNodeImpl, Integer> cartography;

    public ThesaurusCartographyModel(VradiCartographyDTO cartographyDTO) {
        super((Object)1L);
        this.cartography = cartographyDTO.getCartography();
        List forms = cartographyDTO.getForms();
        Set<TreeNodeImpl> keySet = this.cartography.keySet();
        for (TreeNodeImpl treeNodeImpl : keySet) {
            this.nodeList.put(treeNodeImpl.getWikittyId(), new ArrayList());
            this.formList.put(treeNodeImpl.getWikittyId(), new ArrayList());
        }
        for (TreeNodeImpl treeNodeImpl : keySet) {
            String parent = treeNodeImpl.getParent();
            if (parent != null && this.nodeList.containsKey(parent)) {
                List<TreeNodeImpl> list = this.nodeList.get(parent);
                list.add(treeNodeImpl);
                continue;
            }
            this.topLevels.add(treeNodeImpl);
        }
        for (Form form : forms) {
            Set thesaurus = form.getThesaurus();
            if (thesaurus == null || thesaurus.isEmpty()) continue;
            for (String id : thesaurus) {
                if (!this.formList.containsKey(id)) continue;
                List<Form> list = this.formList.get(id);
                list.add(form);
            }
        }
        for (List list : this.nodeList.values()) {
            if (list.isEmpty()) continue;
            Collections.sort(list, VradiComparators.THESAURUS_COMPARATOR_TREENODE);
        }
        Collections.sort(this.topLevels, VradiComparators.THESAURUS_COMPARATOR_TREENODE);
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof TreeNodeImpl) {
            TreeNodeImpl treeNode = (TreeNodeImpl)node;
            if (column == 0) {
                return treeNode.getName();
            }
            if (column == 1) {
                return this.cartography.get(treeNode);
            }
            if (column == 2) {
                List tags = (List)treeNode.getField("Thesaurus", "tags");
                return StringUtils.join((Collection)tags, (char)',');
            }
        }
        return null;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof Long) {
            return this.topLevels.get(index);
        }
        if (parent instanceof TreeNodeImpl) {
            TreeNodeImpl treeNode = (TreeNodeImpl)parent;
            String id = treeNode.getWikittyId();
            List<TreeNodeImpl> list = this.nodeList.get(id);
            return list.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof Long) {
            return this.topLevels.size();
        }
        if (parent instanceof TreeNodeImpl) {
            TreeNodeImpl treeNode = (TreeNodeImpl)parent;
            String id = treeNode.getWikittyId();
            List<TreeNodeImpl> list = this.nodeList.get(id);
            return list.size();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Long) {
            return this.topLevels.indexOf(child);
        }
        if (parent instanceof TreeNodeImpl) {
            TreeNodeImpl treeNode = (TreeNodeImpl)parent;
            String id = treeNode.getWikittyId();
            List<TreeNodeImpl> list = this.nodeList.get(id);
            return list.indexOf(child);
        }
        return -1;
    }

    public String getColumnName(int column) {
        String columnName = null;
        if (column == 0) {
            columnName = I18n._((String)"vradi.thesaurus.name");
        } else if (column == 1) {
            columnName = I18n._((String)"vradi.thesaurus.nbforms");
        } else if (column == 2) {
            columnName = I18n._((String)"vradi.thesaurus.tags");
        }
        return columnName;
    }

    public class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object value2 = value;
            String toolTip = null;
            if (value instanceof TreeNodeImpl) {
                TreeNodeImpl node = (TreeNodeImpl)value;
                value2 = node.getName();
                List<Form> forms = ThesaurusCartographyModel.this.formList.get(node.getWikittyId());
                toolTip = ToolTipHelper.getToolTip(forms);
            }
            JComponent component = (JComponent)super.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
            component.setToolTipText(toolTip);
            return component;
        }
    }
}

